/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block.type.display;

import dev.averageanime.neoforge.block.type.display.FoodBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SmallPlateFoodBlock
extends FoodBlock {
    protected final Supplier<? extends Block> baseBlock;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0);

    public SmallPlateFoodBlock(Supplier<Item> displayItem, Supplier<? extends Block> baseBlock) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), displayItem, 1);
        this.baseBlock = baseBlock;
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected void handleLastItemRemoved(BlockState state, Level level, BlockPos pos) {
        BlockState plateState = this.baseBlock.get().defaultBlockState();
        if (plateState.hasProperty((Property)FACING)) {
            plateState = (BlockState)plateState.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        }
        level.setBlock(pos, plateState, 3);
    }
}

