/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block.type.display;

import dev.averageanime.neoforge.block.type.display.BottleFoodBlock;
import dev.averageanime.neoforge.block.type.display.BowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.PlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.SaladBowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.SmallPlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.plate.EmptyPlateBlock;
import dev.averageanime.neoforge.block.type.display.plate.PlateBlock;
import dev.averageanime.neoforge.block.type.display.plate.SmallPlateBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public abstract class FoodBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty STACK_SIZE = IntegerProperty.create((String)"stack_size", (int)1, (int)9);
    public final int maxStackSize;
    public final Supplier<Item> displayItem;
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);

    public FoodBlock(BlockBehaviour.Properties properties, Supplier<Item> displayItem, int maxStackSize) {
        super(properties);
        this.displayItem = displayItem;
        this.maxStackSize = Math.min(9, Math.max(1, maxStackSize));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)STACK_SIZE, (Comparable)Integer.valueOf(this.maxStackSize)));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack heldStack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (heldStack.is(this.displayItem.get())) {
            return this.addItem(state, level, pos, player, heldStack);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (!level.isClientSide) {
            if (player.isShiftKeyDown()) {
                this.removeAllItems(state, level, pos, player);
            } else {
                this.removeItem(state, level, pos, player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult addItem(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldStack) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        int currentStack = (Integer)state.getValue((Property)STACK_SIZE);
        if (currentStack >= this.maxStackSize) {
            return ItemInteractionResult.FAIL;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)STACK_SIZE, (Comparable)Integer.valueOf(currentStack + 1)), 3);
        if (!player.isCreative()) {
            heldStack.shrink(1);
        }
        level.playSound(null, pos, this.getAddSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return ItemInteractionResult.SUCCESS;
    }

    protected void removeItem(BlockState state, Level level, BlockPos pos, Player player) {
        int currentStack = (Integer)state.getValue((Property)STACK_SIZE);
        Direction direction = player.getDirection().getOpposite();
        ItemStack dropStack = new ItemStack((ItemLike)this.displayItem.get());
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)dropStack, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
        if (currentStack > 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)STACK_SIZE, (Comparable)Integer.valueOf(currentStack - 1)), 3);
        } else {
            this.handleLastItemRemoved(state, level, pos);
        }
        level.playSound(null, pos, this.getRemoveSound(), SoundSource.BLOCKS, 0.8f, 0.8f);
    }

    protected void removeAllItems(BlockState state, Level level, BlockPos pos, Player player) {
        int currentStack = (Integer)state.getValue((Property)STACK_SIZE);
        Direction direction = player.getDirection().getOpposite();
        ItemStack dropStack = new ItemStack((ItemLike)this.displayItem.get(), currentStack);
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)dropStack, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
        this.handleLastItemRemoved(state, level, pos);
        level.playSound(null, pos, this.getRemoveSound(), SoundSource.BLOCKS, 1.0f, 0.8f);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STACK_SIZE});
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return (Integer)state.getValue((Property)STACK_SIZE);
    }

    protected abstract void handleLastItemRemoved(BlockState var1, Level var2, BlockPos var3);

    public SoundEvent getAddSound() {
        return SoundEvents.ITEM_FRAME_ADD_ITEM;
    }

    protected SoundEvent getRemoveSound() {
        return SoundEvents.ITEM_FRAME_REMOVE_ITEM;
    }

    @EventBusSubscriber(modid="createfood", bus=EventBusSubscriber.Bus.GAME)
    public static class PlacementHandler {
        @SubscribeEvent
        public static void onUseItemOnBlock(UseItemOnBlockEvent event) {
            Player player;
            BlockPos clickedPos;
            UseOnContext context = event.getUseOnContext();
            List<Supplier<Block>> displayBlockSuppliers = Registry.getAllBlocks(context.getItemInHand().getItem());
            if (displayBlockSuppliers == null || displayBlockSuppliers.isEmpty()) {
                return;
            }
            Level level = context.getLevel();
            BlockState clickedState = level.getBlockState(clickedPos = context.getClickedPos());
            Block clickedBlock = clickedState.getBlock();
            boolean isCompatPlate = Registry.isCompatBlock(clickedBlock);
            Block compatTargetBlock = isCompatPlate ? Registry.getTargetBlock(clickedBlock) : null;
            Block targetBlock = null;
            for (Supplier<Block> supplier : displayBlockSuppliers) {
                Block block = supplier.get();
                if (block instanceof PlateBlock && (clickedBlock instanceof EmptyPlateBlock || isCompatPlate && compatTargetBlock instanceof EmptyPlateBlock)) {
                    targetBlock = block;
                    break;
                }
                if (block instanceof SmallPlateFoodBlock && (clickedBlock instanceof SmallPlateBlock || isCompatPlate && compatTargetBlock instanceof SmallPlateBlock)) {
                    targetBlock = block;
                    break;
                }
                if (!(block instanceof BottleFoodBlock) && !(block instanceof BowlFoodBlock) && !(block instanceof SaladBowlFoodBlock) && !(block instanceof PlateFoodBlock)) continue;
                targetBlock = block;
                break;
            }
            if (targetBlock == null) {
                return;
            }
            if (targetBlock instanceof PlateBlock) {
                if (!(clickedBlock instanceof EmptyPlateBlock || isCompatPlate && compatTargetBlock instanceof EmptyPlateBlock)) {
                    return;
                }
                if (!isCompatPlate) {
                    return;
                }
            }
            if (targetBlock instanceof SmallPlateFoodBlock) {
                if (!(clickedBlock instanceof SmallPlateBlock || isCompatPlate && compatTargetBlock instanceof SmallPlateBlock)) {
                    event.cancelWithResult(ItemInteractionResult.FAIL);
                    return;
                }
                if (!isCompatPlate) {
                    return;
                }
            }
            if ((targetBlock instanceof BottleFoodBlock || targetBlock instanceof BowlFoodBlock || targetBlock instanceof SaladBowlFoodBlock || targetBlock instanceof PlateFoodBlock) && ((player = context.getPlayer()) == null || !player.isShiftKeyDown())) {
                return;
            }
            if (clickedBlock == targetBlock) {
                return;
            }
            BlockPos placePos = isCompatPlate ? clickedPos : (clickedState.canBeReplaced() ? clickedPos : clickedPos.relative(context.getClickedFace()));
            if (!isCompatPlate && !level.getBlockState(placePos).canBeReplaced()) {
                return;
            }
            if (!level.isClientSide()) {
                BlockState newState = targetBlock.defaultBlockState();
                Direction facing = context.getHorizontalDirection();
                if (clickedState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    facing = (Direction)clickedState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                }
                if (newState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                }
                if (newState.hasProperty((Property)STACK_SIZE)) {
                    newState = (BlockState)newState.setValue((Property)STACK_SIZE, (Comparable)Integer.valueOf(1));
                }
                level.setBlock(placePos, newState, 3);
                if (targetBlock instanceof FoodBlock) {
                    FoodBlock stack = (FoodBlock)targetBlock;
                    level.playSound(null, placePos, stack.getAddSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    level.playSound(null, placePos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (context.getPlayer() != null && !context.getPlayer().isCreative()) {
                    context.getItemInHand().shrink(1);
                }
            }
            event.cancelWithResult(ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()));
        }
    }

    public static class Registry {
        private static final Map<Item, List<Supplier<Block>>> ITEM_TO_BLOCKS = new HashMap<Item, List<Supplier<Block>>>();
        private static final Map<Block, Supplier<Block>> COMPAT_BLOCK_MAPPING = new HashMap<Block, Supplier<Block>>();
        private static final Set<Item> EMPTY_PLATE_ITEMS = new HashSet<Item>();

        public static void register(Supplier<Item> item, Supplier<Block> block) {
            ITEM_TO_BLOCKS.computeIfAbsent(item.get(), k -> new ArrayList()).add(block);
        }

        public static Supplier<Block> getBlock(Item item) {
            List<Supplier<Block>> blocks = ITEM_TO_BLOCKS.get(item);
            return blocks != null && !blocks.isEmpty() ? blocks.get(0) : null;
        }

        public static List<Supplier<Block>> getAllBlocks(Item item) {
            return ITEM_TO_BLOCKS.getOrDefault(item, new ArrayList());
        }

        public static boolean isRegistered(Item item) {
            return ITEM_TO_BLOCKS.containsKey(item);
        }

        public static void registerEmptyPlateItem(Supplier<Item> plateItem) {
            EMPTY_PLATE_ITEMS.add(plateItem.get());
        }

        public static boolean isEmptyPlateItem(Item item) {
            return EMPTY_PLATE_ITEMS.contains(item);
        }

        public static void registerCompatBlock(Block compatBlock, Supplier<Block> targetBlock) {
            COMPAT_BLOCK_MAPPING.put(compatBlock, targetBlock);
        }

        public static boolean isCompatBlock(Block block) {
            return COMPAT_BLOCK_MAPPING.containsKey(block);
        }

        public static Block getTargetBlock(Block compatBlock) {
            Supplier<Block> supplier = COMPAT_BLOCK_MAPPING.get(compatBlock);
            return supplier != null ? supplier.get() : null;
        }

        public static void clear() {
            ITEM_TO_BLOCKS.clear();
            COMPAT_BLOCK_MAPPING.clear();
        }
    }
}

