/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block.type.display;

import dev.averageanime.neoforge.block.type.display.FoodBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BowlFoodBlock
extends FoodBlock {
    protected final VoxelShape shape;
    protected final double shapeHeight;
    private final boolean hasParticles;
    private final Supplier<ParticleOptions> particleType;

    public BowlFoodBlock(Supplier<Item> displayItem) {
        this(displayItem, 0.0, false, null);
    }

    public BowlFoodBlock(Supplier<Item> displayItem, double heightInPixels) {
        this(displayItem, heightInPixels, false, null);
    }

    public BowlFoodBlock(Supplier<Item> displayItem, double heightInPixels, boolean hasParticles, Supplier<ParticleOptions> particleType) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), displayItem, 1);
        this.shapeHeight = Math.max(1.0, Math.min(16.0, heightInPixels));
        this.shape = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)this.shapeHeight, (double)11.0);
        this.hasParticles = hasParticles;
        this.particleType = particleType;
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shape;
    }

    @Override
    protected void handleLastItemRemoved(BlockState state, Level level, BlockPos pos) {
        level.removeBlock(pos, false);
    }

    @Override
    public SoundEvent getAddSound() {
        return SoundEvents.WOOD_PLACE;
    }

    @Override
    protected SoundEvent getRemoveSound() {
        return SoundEvents.WOOD_BREAK;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!this.hasParticles || this.particleType == null) {
            return;
        }
        if (random.nextInt(5) == 0) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.46875;
            double z = (double)pos.getZ() + 0.5;
            double offsetX = (random.nextDouble() - 0.5) * 0.25;
            double offsetZ = (random.nextDouble() - 0.5) * 0.25;
            level.addParticle(this.particleType.get(), x + offsetX, y, z + offsetZ, 0.0, 0.02, 0.0);
        }
    }
}

