/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block.type.cake;

import dev.averageanime.neoforge.block.type.cake.ModCakeBlock;
import dev.averageanime.neoforge.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class GyroMeatBlock
extends ModCakeBlock {
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)11.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)9.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)7.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)5.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)3.0)};

    public GyroMeatBlock(BlockBehaviour.Properties properties) {
        super(properties, (Supplier<Item>)ModItems.GYRO_MEAT_SLICE);
    }

    @Override
    public ItemStack getPieSliceItem() {
        return new ItemStack(ModItems.GYRO_MEAT_SLICE);
    }

    @Override
    @NotNull
    public VoxelShape getShape(BlockState State, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape baseShape = SHAPE_BY_BITE[(Integer)State.getValue((Property)BITES)];
        Direction facing = (Direction)State.getValue((Property)FACING);
        if (facing == Direction.EAST) {
            return this.rotateShape(baseShape, Direction.EAST);
        }
        if (facing == Direction.SOUTH) {
            return this.rotateShape(baseShape, Direction.SOUTH);
        }
        if (facing == Direction.WEST) {
            return this.rotateShape(baseShape, Direction.WEST);
        }
        return baseShape;
    }

    private VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (direction.get2DDataValue() - Direction.NORTH.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }
}

