/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block;

import dev.averageanime.neoforge.CreateFood;
import dev.averageanime.neoforge.block.ModBlocks;
import dev.averageanime.neoforge.block.type.display.BottleFoodBlock;
import dev.averageanime.neoforge.block.type.display.BowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.FoodBlock;
import dev.averageanime.neoforge.block.type.display.PlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.SaladBowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.SmallPlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.plate.ModPlateBlocks;
import dev.averageanime.neoforge.block.type.display.plate.PlateBlock;
import dev.averageanime.neoforge.item.ModItems;
import dev.averageanime.neoforge.item.tooltip.ModTooltips;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModDisplayBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"createfood");
    private static final Set<String> EXCLUDED_ITEMS = Set.of("apple_slice", "cookie_crumbs", "chorus_fruit_slice", "caramel_apple_slice", "waffle_cone", "meat_pie_filling", "dumpling_wrappers", "pumpkin_pie_block", "graham_cracker_chocolate_marshmallow", "graham_cracker_chocolate", "chocolate_graham_cracker_chocolate_ice_cream");
    private static final Map<String, Object> DISPLAY_CONFIGS = new LinkedHashMap<String, Object>();
    public static final DeferredBlock<Block> CREAM_SWEET_ROLL_PLATE;
    public static final DeferredBlock<Block> BAR_OF_CHOCOLATE_PLATE;
    public static final DeferredBlock<Block> PUMPKIN_PIE_PLATE;
    public static final DeferredBlock<Block> BUILDERS_TEA_BLOCK;

    private static void registerConfig(String pattern, DisplayType type) {
        DISPLAY_CONFIGS.put(pattern, new DisplayBlockConfig(type));
    }

    private static void registerConfig(String pattern, DisplayType type, int maxStack) {
        DISPLAY_CONFIGS.put(pattern, new DisplayBlockConfig(type, maxStack));
    }

    private static void registerConfig(String pattern, DisplayType type, double height) {
        DISPLAY_CONFIGS.put(pattern, new DisplayBlockConfig(type, height));
    }

    private static void registerConfig(String pattern, DisplayType type, double height, boolean hasParticles, Supplier<ParticleOptions> particles) {
        DISPLAY_CONFIGS.put(pattern, new DisplayBlockConfig(type, height, hasParticles, particles));
    }

    private static void registerMultiConfig(String pattern, DisplayBlockConfig ... configs) {
        DISPLAY_CONFIGS.put(pattern, new MultiDisplayConfig(configs));
    }

    public static void autoRegisterDisplayBlocks() {
        try {
            Object value2;
            ArrayList<String> itemNames = new ArrayList<String>();
            for (Field field : ModItems.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                try {
                    value2 = field.get(null);
                    if (!(value2 instanceof DeferredItem)) continue;
                    DeferredItem deferredItem = (DeferredItem)value2;
                    String itemName = deferredItem.getId().getPath();
                    itemNames.add(itemName);
                }
                catch (Exception value2) {
                    // empty catch block
                }
            }
            for (Field field : ModBlocks.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                try {
                    DeferredBlock deferredBlock;
                    String blockName;
                    value2 = field.get(null);
                    if (!(value2 instanceof DeferredBlock) || (blockName = (deferredBlock = (DeferredBlock)value2).getId().getPath()).contains("_dessert_block")) continue;
                    itemNames.add(blockName);
                }
                catch (Exception value3) {
                    // empty catch block
                }
            }
            for (String itemName : itemNames) {
                if (EXCLUDED_ITEMS.contains(itemName) || itemName.contains("raw_") || itemName.contains("stick_1") || itemName.contains("stick_2") || itemName.contains("dough") || itemName.contains("chips") || itemName.contains("chocolate_berries") || itemName.contains("chocolate_apple") || itemName.contains("bread_slice") || itemName.contains("toast_slice") || itemName.contains("donut_hole") || itemName.contains("pie_crust") || itemName.contains("sliced")) continue;
                List<DisplayBlockConfig> configs = ModDisplayBlocks.findMatchingConfigs(itemName);
                for (DisplayBlockConfig config : configs) {
                    String blockName = ModDisplayBlocks.getBlockName(itemName, config.type);
                    ModDisplayBlocks.registerDisplayBlock(blockName, itemName, config);
                }
            }
        }
        catch (Exception e) {
            CreateFood.LOGGER.error("Failed to auto-register display blocks", (Throwable)e);
        }
    }

    private static List<DisplayBlockConfig> findMatchingConfigs(String itemName) {
        for (Map.Entry<String, Object> entry : DISPLAY_CONFIGS.entrySet()) {
            if (!itemName.contains(entry.getKey())) continue;
            Object value = entry.getValue();
            if (value instanceof MultiDisplayConfig) {
                MultiDisplayConfig multi = (MultiDisplayConfig)value;
                return multi.configs;
            }
            if (!(value instanceof DisplayBlockConfig)) continue;
            DisplayBlockConfig single = (DisplayBlockConfig)value;
            return Collections.singletonList(single);
        }
        return Collections.emptyList();
    }

    private static String getBlockName(String itemName, DisplayType type) {
        return switch (type.ordinal()) {
            case 0 -> itemName + "_plate_block";
            case 1 -> itemName + "_small_plate_block";
            case 4 -> itemName + "_bowl_block";
            default -> itemName + "_block";
        };
    }

    private static void registerDisplayBlock(String blockName, String itemName, DisplayBlockConfig config) {
        final Supplier<Item> itemSupplier = () -> {
            try {
                Object value;
                for (Field field : ModItems.class.getDeclaredFields()) {
                    DeferredItem deferredItem;
                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !((value = field.get(null)) instanceof DeferredItem) || !(deferredItem = (DeferredItem)value).getId().getPath().equals(itemName)) continue;
                    return (Item)deferredItem.get();
                }
                for (Field field : ModBlocks.class.getDeclaredFields()) {
                    DeferredBlock deferredBlock;
                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !((value = field.get(null)) instanceof DeferredBlock) || !(deferredBlock = (DeferredBlock)value).getId().getPath().equals(itemName)) continue;
                    return ((Block)deferredBlock.get()).asItem();
                }
            }
            catch (Exception e) {
                CreateFood.LOGGER.error("Failed to get item for display block: {}", (Object)itemName, (Object)e);
            }
            return Items.BARRIER;
        };
        final String suffixKey = switch (config.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 5 -> "display.createfood.suffix.plate";
            case 3, 4 -> "display.createfood.suffix.bowl";
            case 2 -> "display.createfood.suffix.bottle";
        };
        DeferredBlock block = BLOCKS.register(blockName, () -> ModDisplayBlocks.createBlock(itemSupplier, config));
        ModItems.ITEMS.register(blockName, () -> new BlockItem((Block)block.get(), new Item.Properties()){

            public Component getName(ItemStack stack) {
                Item originalItem = (Item)itemSupplier.get();
                if (originalItem != null && originalItem != Items.BARRIER) {
                    return Component.translatable((String)"display.createfood.format", (Object[])new Object[]{originalItem.getDescription(), Component.translatable((String)suffixKey)});
                }
                return super.getName(stack);
            }

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
                Item originalItem = (Item)itemSupplier.get();
                if (originalItem != null && originalItem != Items.BARRIER) {
                    ItemStack originalStack = new ItemStack((ItemLike)originalItem);
                    originalItem.appendHoverText(originalStack, context, components, flag);
                }
                super.appendHoverText(stack, context, components, flag);
            }
        });
    }

    private static Block createBlock(Supplier<Item> itemSupplier, DisplayBlockConfig config) {
        return switch (config.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new PlateBlock(itemSupplier, config.maxStack, (Supplier<? extends Block>)ModBlocks.PLATE_BLOCK);
            case 1 -> new SmallPlateFoodBlock(itemSupplier, (Supplier<? extends Block>)ModBlocks.SMALL_PLATE_BLOCK);
            case 2 -> new BottleFoodBlock(itemSupplier, config.height, config.hasParticles, config.particleType);
            case 3 -> new BowlFoodBlock(itemSupplier, config.height, config.hasParticles, config.particleType);
            case 4 -> new SaladBowlFoodBlock(itemSupplier);
            case 5 -> new PlateFoodBlock(itemSupplier);
        };
    }

    @NotNull
    public static DeferredBlock<Block> registerPlateBlock(String name, Supplier<Item> foodItem, int maxStack, final String compatTooltip, final String ... ingredientTooltips) {
        DeferredBlock block = BLOCKS.register(name, () -> new PlateBlock(foodItem, maxStack, (Supplier<? extends Block>)ModBlocks.PLATE_BLOCK));
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()){

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
                ModTooltips.addTooltip(components, compatTooltip, ingredientTooltips);
                super.appendHoverText(stack, context, components, flag);
            }
        });
        return block;
    }

    @NotNull
    public static DeferredBlock<Block> registerPlateBlock(String name, Supplier<Item> foodItem, int maxStack) {
        DeferredBlock block = BLOCKS.register(name, () -> new PlateBlock(foodItem, maxStack, (Supplier<? extends Block>)ModBlocks.PLATE_BLOCK));
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()){});
        return block;
    }

    @NotNull
    public static DeferredBlock<Block> registerPlateBlockFromBlock(String name, Supplier<Block> foodBlock, int maxStack) {
        final Supplier<Item> itemSupplier = () -> ((Block)foodBlock.get()).asItem();
        DeferredBlock block = BLOCKS.register(name, () -> new PlateBlock(itemSupplier, maxStack, (Supplier<? extends Block>)ModBlocks.PLATE_BLOCK));
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()){

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
                Item originalItem = (Item)itemSupplier.get();
                if (originalItem != null && originalItem != Items.BARRIER) {
                    ItemStack originalStack = new ItemStack((ItemLike)originalItem);
                    originalItem.appendHoverText(originalStack, context, components, flag);
                }
                super.appendHoverText(stack, context, components, flag);
            }
        });
        return block;
    }

    @NotNull
    public static DeferredBlock<Block> registerPlateBlockFromBlock(String name, Supplier<Block> foodBlock, int maxStack, final String compatTooltip, final String ... ingredientTooltips) {
        final Supplier<Item> itemSupplier = () -> ((Block)foodBlock.get()).asItem();
        DeferredBlock block = BLOCKS.register(name, () -> new PlateBlock(itemSupplier, maxStack, (Supplier<? extends Block>)ModBlocks.PLATE_BLOCK));
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()){

            public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
                Item originalItem = (Item)itemSupplier.get();
                if (originalItem != null && originalItem != Items.BARRIER) {
                    ItemStack originalStack = new ItemStack((ItemLike)originalItem);
                    originalItem.appendHoverText(originalStack, context, components, flag);
                }
                ModTooltips.addTooltip(components, compatTooltip, ingredientTooltips);
                super.appendHoverText(stack, context, components, flag);
            }
        });
        return block;
    }

    @NotNull
    public static DeferredBlock<Block> registerBottleBlock(String name, Supplier<Item> foodItem, double heightInPixels, boolean hasParticles, Supplier<ParticleOptions> particleType, final String compatTooltip, final String ... ingredientTooltips) {
        DeferredBlock block = BLOCKS.register(name, () -> new BottleFoodBlock(foodItem, heightInPixels, hasParticles, particleType));
        if (compatTooltip != null && !compatTooltip.isEmpty() || ingredientTooltips != null && ingredientTooltips.length > 0) {
            ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()){

                public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
                    ModTooltips.addTooltip(components, compatTooltip, ingredientTooltips);
                    super.appendHoverText(stack, context, components, flag);
                }
            });
        } else {
            ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    private static Supplier<Item> createCompatItemSupplier(String modItemId) {
        return () -> {
            try {
                ResourceLocation itemRL = ResourceLocation.parse((String)modItemId);
                Item item = (Item)BuiltInRegistries.ITEM.get(itemRL);
                return item != null && item != Items.AIR ? item : Items.BARRIER;
            }
            catch (Exception e) {
                return Items.BARRIER;
            }
        };
    }

    public static void registerBlockItems() {
        BLOCKS.getEntries().forEach(blockEntry -> {
            Block block = (Block)blockEntry.get();
            if (block instanceof FoodBlock) {
                FoodBlock displayableBlock = (FoodBlock)block;
                Item displayItem = displayableBlock.displayItem.get();
                FoodBlock.Registry.register(() -> displayItem, (Supplier<Block>)blockEntry);
            }
        });
    }

    public static void register(IEventBus eventBus) {
        CreateFood.LOGGER.info("Create: Food - Registering Display Blocks");
        ModDisplayBlocks.autoRegisterDisplayBlocks();
        BLOCKS.register(eventBus);
        eventBus.addListener(event -> event.enqueueWork(() -> {
            ModDisplayBlocks.registerBlockItems();
            ModPlateBlocks.registerCompatiblePlates();
        }));
    }

    static {
        ModDisplayBlocks.registerConfig("gelatin_dessert", DisplayType.PLATE, 6);
        ModDisplayBlocks.registerConfig("slice", DisplayType.SMALL_PLATE);
        ModDisplayBlocks.registerConfig("cream_mini_waffle", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("honeyed_mini_waffle", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("mini_waffle", DisplayType.PLATE, 4);
        ModDisplayBlocks.registerConfig("pizza", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("cheese_block", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("gyro", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("waffle", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("cupcake", DisplayType.PLATE, 4);
        ModDisplayBlocks.registerConfig("cake", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("mini_cream_pie", DisplayType.SMALL_PLATE);
        ModDisplayBlocks.registerConfig("mini_smores_pie", DisplayType.SMALL_PLATE);
        ModDisplayBlocks.registerConfig("mini_cookie_cream_pie", DisplayType.SMALL_PLATE);
        ModDisplayBlocks.registerConfig("mini_chocolate_pie", DisplayType.SMALL_PLATE);
        ModDisplayBlocks.registerConfig("pie", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("burger", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("meatball_sandwich", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("hash_brown_sandwich", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("sandwich", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("toast_plate", DisplayType.PLATE_FOOD);
        ModDisplayBlocks.registerConfig("toast_fried_egg_plate", DisplayType.PLATE_FOOD);
        ModDisplayBlocks.registerConfig("toast", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("calzone", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("smore", DisplayType.PLATE, 1);
        ModDisplayBlocks.registerConfig("hot_chocolate_bottle", DisplayType.BOTTLE, 8.0, true, () -> ParticleTypes.WHITE_SMOKE);
        ModDisplayBlocks.registerConfig("hot_dark_chocolate_bottle", DisplayType.BOTTLE, 8.0, true, () -> ParticleTypes.WHITE_SMOKE);
        ModDisplayBlocks.registerConfig("hot_white_chocolate_bottle", DisplayType.BOTTLE, 8.0, true, () -> ParticleTypes.WHITE_SMOKE);
        ModDisplayBlocks.registerConfig("_jam_bottle", DisplayType.BOTTLE, 9.0, false, null);
        ModDisplayBlocks.registerConfig("_juice_bottle", DisplayType.BOTTLE, 10.0, false, null);
        ModDisplayBlocks.registerConfig("chocolate_bottle", DisplayType.BOTTLE, 8.0, false, null);
        ModDisplayBlocks.registerConfig("dark_chocolate_bottle", DisplayType.BOTTLE, 8.0, false, null);
        ModDisplayBlocks.registerConfig("white_chocolate_bottle", DisplayType.BOTTLE, 8.0, false, null);
        ModDisplayBlocks.registerConfig("chocolate_milk_bottle", DisplayType.BOTTLE, 8.0, false, null);
        ModDisplayBlocks.registerConfig("fruit_smoothie_bottle", DisplayType.BOTTLE, 8.0, false, null);
        ModDisplayBlocks.registerConfig("_bottle", DisplayType.BOTTLE, 12.0, false, null);
        ModDisplayBlocks.registerConfig("ice_cream_bowl", DisplayType.BOWL, 4.5, true, () -> ParticleTypes.SNOWFLAKE);
        ModDisplayBlocks.registerConfig("soup_bowl", DisplayType.BOWL, 4.0, true, () -> ParticleTypes.WHITE_SMOKE);
        ModDisplayBlocks.registerConfig("stew_bowl", DisplayType.BOWL, 4.0, true, () -> ParticleTypes.WHITE_SMOKE);
        ModDisplayBlocks.registerConfig("_bowl", DisplayType.BOWL, 4.0, false, null);
        ModDisplayBlocks.registerConfig("salad", DisplayType.SALAD_BOWL);
        ModDisplayBlocks.registerConfig("pasta_plate", DisplayType.PLATE_FOOD);
        ModDisplayBlocks.registerConfig("breakfast_plate", DisplayType.PLATE_FOOD);
        ModDisplayBlocks.registerConfig("egg_plate", DisplayType.PLATE_FOOD);
        ModDisplayBlocks.registerConfig("hash_brown_plate", DisplayType.PLATE_FOOD);
        ModDisplayBlocks.registerConfig("cookie", DisplayType.PLATE, 4);
        ModDisplayBlocks.registerConfig("wrap", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("ice_cream_stick", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("corn_stick", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("cotton_candy_stick", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("stick", DisplayType.PLATE, 3);
        ModDisplayBlocks.registerConfig("cone", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("muffin", DisplayType.PLATE, 4);
        ModDisplayBlocks.registerConfig("pastry", DisplayType.PLATE, 4);
        ModDisplayBlocks.registerConfig("sweet_roll", DisplayType.PLATE, 4);
        ModDisplayBlocks.registerConfig("donut", DisplayType.PLATE, 5);
        ModDisplayBlocks.registerConfig("fudge", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("bar_of", DisplayType.PLATE, 6);
        ModDisplayBlocks.registerConfig("popsicle", DisplayType.PLATE, 2);
        ModDisplayBlocks.registerConfig("breakfast_bar", DisplayType.PLATE, 6);
        ModDisplayBlocks.registerMultiConfig("baked_potato", new DisplayBlockConfig(DisplayType.PLATE, 3), new DisplayBlockConfig(DisplayType.SMALL_PLATE));
        ModDisplayBlocks.registerConfig("_chocolate", DisplayType.PLATE, 6);
        CREAM_SWEET_ROLL_PLATE = ModDisplayBlocks.registerPlateBlock("cream_sweet_roll_plate_block", ModDisplayBlocks.createCompatItemSupplier("create:sweet_roll"), 4, null, "tooltip.createfood.cream_frosting_ingredient");
        BAR_OF_CHOCOLATE_PLATE = ModDisplayBlocks.registerPlateBlock("bar_of_chocolate_plate_block", ModDisplayBlocks.createCompatItemSupplier("create:bar_of_chocolate"), 6);
        PUMPKIN_PIE_PLATE = ModDisplayBlocks.registerPlateBlock("pumpkin_pie_plate_block", ModDisplayBlocks.createCompatItemSupplier("minecraft:pumpkin_pie"), 1);
        BUILDERS_TEA_BLOCK = ModDisplayBlocks.registerBottleBlock("builders_tea_bottle_block", ModDisplayBlocks.createCompatItemSupplier("create:builders_tea"), 10.0, true, () -> ParticleTypes.WHITE_SMOKE, null, new String[0]);
    }

    private static class DisplayBlockConfig {
        final DisplayType type;
        final int maxStack;
        final double height;
        final boolean hasParticles;
        final Supplier<ParticleOptions> particleType;

        DisplayBlockConfig(DisplayType type) {
            this(type, 1, 12.0, false, null);
        }

        DisplayBlockConfig(DisplayType type, int maxStack) {
            this(type, maxStack, 12.0, false, null);
        }

        DisplayBlockConfig(DisplayType type, double height) {
            this(type, 1, height, false, null);
        }

        DisplayBlockConfig(DisplayType type, double height, boolean hasParticles, Supplier<ParticleOptions> particleType) {
            this(type, 1, height, hasParticles, particleType);
        }

        DisplayBlockConfig(DisplayType type, int maxStack, double height, boolean hasParticles, Supplier<ParticleOptions> particleType) {
            this.type = type;
            this.maxStack = maxStack;
            this.height = height;
            this.hasParticles = hasParticles;
            this.particleType = particleType;
        }
    }

    private static enum DisplayType {
        PLATE,
        SMALL_PLATE,
        BOTTLE,
        BOWL,
        SALAD_BOWL,
        PLATE_FOOD;

    }

    private static class MultiDisplayConfig {
        final List<DisplayBlockConfig> configs;

        MultiDisplayConfig(DisplayBlockConfig ... configs) {
            this.configs = Arrays.asList(configs);
        }
    }
}

