/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge;

import com.mojang.logging.LogUtils;
import dev.averageanime.neoforge.block.ModBlocks;
import dev.averageanime.neoforge.block.ModDisplayBlocks;
import dev.averageanime.neoforge.config.ConfigScreen;
import dev.averageanime.neoforge.config.ModConfig;
import dev.averageanime.neoforge.config.condition.ModConditions;
import dev.averageanime.neoforge.fluid.FluidEntry;
import dev.averageanime.neoforge.fluid.ModFluids;
import dev.averageanime.neoforge.item.ModItems;
import dev.averageanime.neoforge.tab.ModTabs;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="createfood")
public class CreateFood {
    public static final Logger LOGGER = LogUtils.getLogger();

    public CreateFood(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfig.BUILDER.build(), "createfood-client.toml");
        modEventBus.addListener(event -> {
            ConfigScreen factory = new ConfigScreen();
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)factory);
        });
        ModConditions.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModDisplayBlocks.register(modEventBus);
        ModFluids.register(modEventBus);
        ModTabs.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Create: Food - Startup");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Create: Food - Server Startup");
    }

    @EventBusSubscriber(modid="createfood", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ClientModEvents.setFluidRenderLayers(ModFluids.SQUID_INK_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.VEGETABLE_OIL_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.VINEGAR_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.APPLE_JUICE_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.BERRY_JUICE_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.CHORUS_FRUIT_JUICE_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.GLOW_BERRY_JUICE_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.BLACK_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.BLUE_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.BROWN_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.CYAN_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.GRAY_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.GREEN_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.LIGHT_BLUE_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.LIGHT_GRAY_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.LIME_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.MAGENTA_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.ORANGE_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.PINK_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.PURPLE_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.RED_GELATIN_MIX_FLUID);
            ClientModEvents.setFluidRenderLayers(ModFluids.YELLOW_GELATIN_MIX_FLUID);
        }

        private static void setFluidRenderLayers(FluidEntry.FluidType fluid) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)fluid.FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)fluid.SOURCE.get()), (RenderType)RenderType.translucent());
        }
    }
}

