/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.audio.Listener;
import dynamic_fps.impl.feature.volume.SmoothVolumeHandler;
import dynamic_fps.impl.util.Logging;
import dynamic_fps.impl.util.duck.DuckSoundEngine;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public class SoundEngineMixin
implements DuckSoundEngine {
    @Shadow
    @Final
    private Options options;
    @Shadow
    private boolean loaded;
    @Shadow
    @Final
    private Listener listener;
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;
    @Unique
    private static final Minecraft dynamic_fps$minecraft = Minecraft.getInstance();

    @Shadow
    private float calculateVolume(SoundInstance instance) {
        throw new RuntimeException("Failed to find SoundEngine.calculateVolume.");
    }

    @Override
    public void dynamic_fps$updateVolume(SoundSource source) {
        ArrayList<SoundInstance> sounds;
        if (!this.loaded) {
            return;
        }
        if (source.equals((Object)SoundSource.MASTER)) {
            float volume = this.options.getSoundSourceVolume(source);
            this.listener.setGain(this.dynamic_fps$adjustVolume(volume, source));
            return;
        }
        boolean isMusic = source.equals((Object)SoundSource.MUSIC) || source.equals((Object)SoundSource.RECORDS);
        try {
            sounds = new ArrayList<SoundInstance>(this.instanceToChannel.keySet());
        }
        catch (Throwable e) {
            Logging.getLogger().error("Unable to update source volume!", e);
            return;
        }
        for (SoundInstance instance : sounds) {
            ChannelAccess.ChannelHandle handle = this.instanceToChannel.get(instance);
            if (handle == null || !instance.getSource().equals((Object)source)) continue;
            float volume = this.calculateVolume(instance);
            handle.execute(channel -> {
                if (volume <= 0.0f) {
                    if (isMusic) {
                        channel.pause();
                    } else if (!dynamic_fps$minecraft.isPaused()) {
                        channel.setVolume(volume);
                    }
                } else {
                    if (isMusic && !dynamic_fps$minecraft.isPaused()) {
                        channel.unpause();
                    }
                    channel.setVolume(volume);
                }
            });
        }
    }

    @Inject(method={"play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V", "playDelayed(Lnet/minecraft/client/resources/sounds/SoundInstance;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void play(SoundInstance instance, CallbackInfo callbackInfo) {
        if (SmoothVolumeHandler.volumeMultiplier(instance.getSource()) == 0.0f) {
            callbackInfo.cancel();
        }
    }

    @ModifyReturnValue(method={"getVolume(Lnet/minecraft/sounds/SoundSource;)F"}, at={@At(value="RETURN")})
    private float getVolume(float original, @Local(argsOnly=true) @Nullable SoundSource source) {
        return this.dynamic_fps$adjustVolume(original, source);
    }

    @Unique
    private float dynamic_fps$adjustVolume(float value, @Nullable SoundSource source) {
        if (source == null) {
            source = SoundSource.MASTER;
        }
        return value * SmoothVolumeHandler.volumeMultiplier(source);
    }
}

