/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.battery;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.feature.battery.ErrorToast;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.Components;
import dynamic_fps.impl.util.Logging;
import dynamic_fps.impl.util.Threads;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import net.lostluma.battery.api.Battery;
import net.lostluma.battery.api.Manager;
import net.lostluma.battery.api.State;
import net.lostluma.battery.api.exception.LibraryLoadError;
import net.lostluma.battery.api.exception.NetworkError;
import net.lostluma.battery.api.util.Library;
import net.lostluma.battery.api.util.Testing;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class BatteryTracker {
    private static boolean readInitialData = false;
    private static volatile int charge = 0;
    private static volatile State status = State.UNKNOWN;
    @Nullable
    private static Manager manager = null;
    private static Collection<Battery> batteries = Collections.emptyList();
    private static boolean threadStarted = false;
    private static final Duration updateInterval = Duration.of(15L, ChronoUnit.SECONDS);

    public static int charge() {
        return charge;
    }

    public static State status() {
        return status;
    }

    public static boolean hasBatteries() {
        return !batteries.isEmpty();
    }

    public static void init() {
        if (manager != null) {
            manager.close();
            manager = null;
            batteries = Collections.emptyList();
        }
        if (!BatteryTracker.isFeatureEnabled()) {
            return;
        }
        BatteryTracker.customizeInstallation();
        Manager temp = BatteryTracker.createManager();
        batteries = BatteryTracker.getBatteries(temp);
        if (batteries.isEmpty()) {
            if (temp != null) {
                temp.close();
            }
        } else {
            manager = temp;
            if (!threadStarted) {
                threadStarted = true;
                Threads.create("refresh-battery", BatteryTracker::updateBatteries);
            }
        }
    }

    public static boolean isFeatureEnabled() {
        return DynamicFPSConfig.INSTANCE.batteryTracker().enabled();
    }

    private static State mergeStates(State a, State b) {
        if (a == b) {
            return a;
        }
        if (a == State.CHARGING || b == State.CHARGING) {
            return State.CHARGING;
        }
        if (a == State.DISCHARGING || b == State.DISCHARGING) {
            return State.DISCHARGING;
        }
        return a == State.UNKNOWN ? b : a;
    }

    private static void updateState() {
        boolean changed = false;
        float total_joules = 0.0f;
        float total_percent = 0.0f;
        State newStatus = State.UNKNOWN;
        for (Battery battery : batteries) {
            float capacity = battery.energyFull().joules();
            newStatus = BatteryTracker.mergeStates(newStatus, battery.state());
            total_joules += capacity;
            total_percent += capacity * battery.stateOfCharge().percent();
        }
        int newCharge = Math.round(total_percent / total_joules);
        if (readInitialData && charge != newCharge) {
            changed = true;
            int current = charge;
            Threads.runOnMainThread(() -> DynamicFPSMod.onBatteryChargeChanged(current, newCharge));
        }
        if (readInitialData && status != newStatus) {
            changed = true;
            State current = status;
            State updated = newStatus;
            Threads.runOnMainThread(() -> DynamicFPSMod.onBatteryStatusChanged(current, updated));
        }
        charge = newCharge;
        status = newStatus;
        if (!readInitialData || changed) {
            readInitialData = true;
            DynamicFPSMod.onStatusChanged(false);
        }
    }

    private static void updateBatteries() {
        boolean active = true;
        while (active) {
            for (Battery battery : batteries) {
                try {
                    battery.update();
                }
                catch (IOException e) {
                    Logging.getLogger().warn("Failed to update battery!", (Throwable)e);
                }
            }
            BatteryTracker.updateState();
            try {
                Thread.sleep(updateInterval);
            }
            catch (InterruptedException e) {
                active = false;
                Thread.currentThread().interrupt();
            }
        }
        if (manager != null) {
            manager.close();
        }
    }

    private static void customizeInstallation() {
        Library.setCacheDir((Path)Platform.getInstance().getCacheDir());
        Library.setAllowDownloads((boolean)DynamicFPSConfig.INSTANCE.downloadNatives());
    }

    private static Manager createManager() {
        Manager result = null;
        try {
            result = !DynamicFPSConfig.INSTANCE.mockBatteryData() ? Manager.create() : Testing.mockManager();
        }
        catch (IOException e) {
            Logging.getLogger().warn("Failed to create battery manager!", (Throwable)e);
        }
        catch (LibraryLoadError e) {
            Logging.getLogger().warn("Battery tracker feature unavailable!");
            String path = e instanceof NetworkError ? "http_error" : (DynamicFPSConfig.INSTANCE.downloadNatives() ? "no_support" : "no_library");
            Threads.runOnMainThread(() -> ErrorToast.queueToast((Component)Components.translatable("toast", path, new Object[0])));
        }
        return result;
    }

    private static Collection<Battery> getBatteries(@Nullable Manager manager) {
        Collection<Object> result = Collections.emptyList();
        if (manager == null) {
            return result;
        }
        try {
            result = manager.batteries();
        }
        catch (IOException e) {
            Logging.getLogger().warn("Failed to query system batteries!", (Throwable)e);
        }
        return result;
    }
}

