/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RecipeTemplate {
    private static final Map<Class<? extends Recipe<?>>, TriFunction<Recipe<?>, BlockType, BlockType, Recipe<?>>> REMAPPERS = new HashMap();

    public static <R extends Recipe<?>> void registerSimple(Class<R> type, RecipeFactory<R> factory) {
        RecipeTemplate.register(type, (R r, BlockType f, BlockType t) -> RecipeTemplate.createSimple(r, factory, f, t));
    }

    @Deprecated(forRemoval=true)
    public static <R extends Recipe<?>> void register(Class<R> type, BiFunction<R, UnaryOperator<ItemStack>, R> factory) {
        if (PlatHelper.isDev()) {
            throw new UnsupportedOperationException("You must register this using RecipeTemplate.register()");
        }
    }

    public static <R extends Recipe<?>> void register(Class<R> type, TriFunction<R, BlockType, BlockType, R> factory) {
        REMAPPERS.put(type, (r, f, t) -> (Recipe)factory.apply((Object)r, (BlockType)f, (BlockType)t));
    }

    @Deprecated(forRemoval=true)
    public static <T extends BlockType, R extends Recipe<?>> RecipeHolder<?> makeSimilarRecipe(R original, T originalMat, T destinationMat, String baseID) {
        return RecipeTemplate.makeSimilarRecipe(original, originalMat, destinationMat, ResourceLocation.parse((String)baseID));
    }

    public static <T extends BlockType, R extends Recipe<?>> RecipeHolder<?> makeSimilarRecipe(R original, @NotNull T originalMat, @NotNull T destinationMat, ResourceLocation baseID) {
        Class clazz = original.getClass();
        TriFunction<Recipe<?>, BlockType, BlockType, Recipe<?>> remapper = REMAPPERS.get(clazz);
        if (remapper == null) {
            throw new UnsupportedOperationException("Recipe class " + String.valueOf(clazz) + " not supported. You must register it using RecipeTemplate.register()");
        }
        ResourceLocation newId = baseID.withPath(p -> p + "/" + destinationMat.getAppendableId());
        Preconditions.checkNotNull(original, (Object)("Found null from block type for remapping for recipe " + String.valueOf(originalMat) + " with id " + String.valueOf(newId)));
        Preconditions.checkNotNull(originalMat, (Object)("Found null from block type for remapping for recipe " + String.valueOf(originalMat) + " with id " + String.valueOf(newId)));
        Recipe<?> remapped = remapper.apply(original, originalMat, destinationMat);
        return new RecipeHolder(newId, remapped);
    }

    private static <R extends Recipe<?>> R createSimple(R or, RecipeFactory<R> factory, @NotNull BlockType from, @NotNull BlockType to) {
        Preconditions.checkNotNull((Object)from, (Object)("Found null from block type for recipe remapping on recipe " + String.valueOf(or)));
        Preconditions.checkNotNull((Object)to, (Object)("Found null to block type for recipe remapping on recipe " + String.valueOf(or)));
        List<Ingredient> newList = RecipeTemplate.convertIngredients((NonNullList<Ingredient>)or.getIngredients(), from, to);
        ItemStack originalResult = or.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
        ItemStack newResult = RecipeTemplate.convertItemStack(originalResult, from, to);
        NonNullList ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])newList.toArray(Ingredient[]::new)));
        CraftingBookCategory cat = CraftingBookCategory.MISC;
        if (or instanceof CraftingRecipe) {
            CraftingRecipe cr = (CraftingRecipe)or;
            cat = cr.category();
        }
        return factory.create(or.getGroup(), cat, newResult, (NonNullList<Ingredient>)ingredients);
    }

    private static ShapedRecipe createShaped(ShapedRecipe or, @NotNull BlockType from, @NotNull BlockType to) {
        Preconditions.checkNotNull((Object)from, (Object)("Found null from block type for recipe remapping on recipe " + String.valueOf(or)));
        Preconditions.checkNotNull((Object)to, (Object)("Found null to block type for recipe remapping on recipe " + String.valueOf(or)));
        List<Ingredient> newList = RecipeTemplate.convertIngredients((NonNullList<Ingredient>)or.getIngredients(), from, to);
        ItemStack originalResult = or.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
        ItemStack newResult = RecipeTemplate.convertItemStack(originalResult, from, to);
        NonNullList ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])newList.toArray(Ingredient[]::new)));
        ShapedRecipePattern pattern = new ShapedRecipePattern(or.getWidth(), or.getHeight(), ingredients, Optional.of(RecipeTemplate.packRecipePattern(or.getWidth(), or.getHeight(), (NonNullList<Ingredient>)ingredients)));
        return new ShapedRecipe(or.getGroup(), or.category(), pattern, newResult);
    }

    private static ShapedRecipePattern.Data packRecipePattern(int width, int height, NonNullList<Ingredient> ingredients) {
        HashMap<Character, Ingredient> key = new HashMap<Character, Ingredient>();
        ArrayList<String> pattern = new ArrayList<String>();
        char nextSymbol = 'A';
        for (int row = 0; row < height; ++row) {
            StringBuilder rowPattern = new StringBuilder();
            for (int col = 0; col < width; ++col) {
                Ingredient ingredient = (Ingredient)ingredients.get(row * width + col);
                if (ingredient.isEmpty()) {
                    rowPattern.append(' ');
                    continue;
                }
                Character symbol = null;
                for (Map.Entry entry : key.entrySet()) {
                    if (entry.getValue() != ingredient) continue;
                    symbol = (Character)entry.getKey();
                    break;
                }
                if (symbol == null) {
                    char c = nextSymbol;
                    nextSymbol = (char)(nextSymbol + 1);
                    symbol = Character.valueOf(c);
                    key.put(symbol, ingredient);
                }
                rowPattern.append(symbol);
            }
            pattern.add(rowPattern.toString());
        }
        return new ShapedRecipePattern.Data(key, pattern);
    }

    public static <T extends BlockType> ItemStack convertItemStack(ItemStack original, T from, T to) {
        Item changed = BlockType.changeItemType(original.getItem(), from, to);
        if (changed == null) {
            throw new UnsupportedOperationException("Failed to convert item stack: could not change " + String.valueOf(original.getItem()) + " from " + String.valueOf(from.getId()) + " to " + String.valueOf(to.getId()));
        }
        return original.transmuteCopy((ItemLike)changed);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static <R extends Recipe<?>> List<Ingredient> convertIngredients(NonNullList<Ingredient> or, UnaryOperator<ItemStack> typeChanger) {
        ArrayList<Ingredient> newList = new ArrayList<Ingredient>((Collection<Ingredient>)or);
        for (int i = 0; i < newList.size(); ++i) {
            ItemStack intItem;
            Ingredient ingredient = (Ingredient)or.get(i);
            if (ingredient.isEmpty() || (intItem = (ItemStack)typeChanger.apply(ingredient.getItems()[0])) == null) continue;
            newList.set(i, Ingredient.of((ItemStack[])new ItemStack[]{intItem}));
        }
        return newList;
    }

    @NotNull
    public static <R extends Recipe<?>> List<Ingredient> convertIngredients(NonNullList<Ingredient> or, @NotNull BlockType from, @NotNull BlockType to) {
        ArrayList<Ingredient> newList = new ArrayList<Ingredient>();
        HashMap<Ingredient, Ingredient> convertedMap = new HashMap<Ingredient, Ingredient>();
        for (Ingredient ingredient : or) {
            if (ingredient.isEmpty()) {
                newList.add(ingredient);
                continue;
            }
            newList.add(convertedMap.computeIfAbsent(ingredient, i -> BlockTypeSwapIngredient.create(i, from, to)));
        }
        return newList;
    }

    static {
        RecipeTemplate.register(ShapedRecipe.class, RecipeTemplate::createShaped);
        RecipeTemplate.registerSimple(ShapelessRecipe.class, ShapelessRecipe::new);
        RecipeTemplate.registerSimple(StonecutterRecipe.class, (group, category, result, ingredients) -> new StonecutterRecipe(group, (Ingredient)ingredients.getFirst(), result));
        RecipeTemplate.register(SmeltingRecipe.class, (R recipe, BlockType oldType, BlockType newType) -> RecipeTemplate.createSimple(recipe, (group, category, result, ingredients) -> new SmeltingRecipe(group, recipe.category(), (Ingredient)ingredients.getFirst(), result, recipe.getExperience(), recipe.getCookingTime()), oldType, newType));
    }

    public static interface RecipeFactory<R extends Recipe<?>> {
        public R create(String var1, CraftingBookCategory var2, ItemStack var3, NonNullList<Ingredient> var4);
    }
}

