/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.neoforge.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.createcobblestone.neoforge.CreateCobblestoneNeoForge;
import net.createcobblestone.neoforge.data.GeneratorType;
import net.createcobblestone.neoforge.data.GeneratorTypesPayload;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.network.PacketDistributor;

public class GeneratorTypeLoader {
    public static boolean loaded = false;
    public static List<GeneratorTypesPayload.GeneratorTypePayload> loadedTypes = new ArrayList<GeneratorTypesPayload.GeneratorTypePayload>();

    public static void loadGeneratorTypes(ResourceManager resourceManager) {
        loaded = false;
        GeneratorType.init();
        loadedTypes.clear();
        CreateCobblestoneNeoForge.LOGGER.info("Loading generator types from datapacks");
        Map resources = resourceManager.listResources("generator_types", location -> location.getPath().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                InputStream inputStream = resource.open();
                try {
                    JsonObject generatorJsonData = JsonParser.parseString((String)new String(inputStream.readAllBytes())).getAsJsonObject();
                    String block = generatorJsonData.get("block").getAsString();
                    if (BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)block)) == Blocks.AIR) {
                        CreateCobblestoneNeoForge.LOGGER.error("Generator type {} has no block assigned", (Object)id);
                    }
                    int generatorStress = -1;
                    float outputPerSecondPerRpm = -1.0f;
                    int generatorStorage = -1;
                    if (generatorJsonData.has("enabled") && !generatorJsonData.get("enabled").getAsBoolean()) continue;
                    if (generatorJsonData.has("stress")) {
                        generatorStress = generatorJsonData.get("stress").getAsInt();
                    }
                    if (generatorJsonData.has("outputPerSecondPerRpm")) {
                        outputPerSecondPerRpm = generatorJsonData.get("outputPerSecondPerRpm").getAsFloat();
                    }
                    if (generatorJsonData.has("storage")) {
                        generatorStorage = generatorJsonData.get("storage").getAsInt();
                    }
                    if (generatorJsonData.has("ratio")) {
                        if (generatorJsonData.has("outputPerSecondPerRpm")) {
                            CreateCobblestoneNeoForge.LOGGER.error("Generator type {} has both ratio and outputPerSecondPerRpm, outputPerSecondPerRpm will be used", (Object)id);
                        } else {
                            CreateCobblestoneNeoForge.LOGGER.warn("Generator type {} has deprecated ratio, please use outputPerSecondPerRpm instead. (Converted to {} outputPerSecondPerRpm)", (Object)id, (Object)Float.valueOf(1.0f / generatorJsonData.get("ratio").getAsFloat() * 20.0f));
                            outputPerSecondPerRpm = 1.0f / generatorJsonData.get("ratio").getAsFloat() * 20.0f;
                        }
                    }
                    loadedTypes.add(new GeneratorTypesPayload.GeneratorTypePayload(id.toString(), block, generatorStress, outputPerSecondPerRpm, generatorStorage));
                    GeneratorType.initializeNewType(id.toString(), ResourceLocation.parse((String)block), generatorStress, outputPerSecondPerRpm, generatorStorage);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                CreateCobblestoneNeoForge.LOGGER.error("Error loading generator type: " + String.valueOf(id), (Throwable)e);
            }
        }
        loaded = true;
        CreateCobblestoneNeoForge.LOGGER.info("Generator types loading done");
    }

    public static void sendGeneratorTypesToClient(Iterable<ServerPlayer> players) {
        GeneratorTypesPayload payload = new GeneratorTypesPayload(List.copyOf(loadedTypes));
        int count = 0;
        for (ServerPlayer p : players) {
            PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            ++count;
        }
        CreateCobblestoneNeoForge.LOGGER.info("Sent generator update payload ({} entries) to {} player(s)", (Object)payload.list().size(), (Object)count);
    }

    public static void loadGeneratorTypesFromPacket(GeneratorTypesPayload payload) {
        CreateCobblestoneNeoForge.LOGGER.info("Received generator update payload ({} entries)", (Object)payload.list().size());
        loaded = false;
        GeneratorType.init();
        for (GeneratorTypesPayload.GeneratorTypePayload g : payload.list()) {
            GeneratorType.initializeNewType(g.id(), ResourceLocation.parse((String)g.block()), g.stress(), g.ratio(), g.storage());
        }
        loaded = true;
    }

    public static void register() {
    }
}

