/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.neoforge.blocks;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import net.createcobblestone.neoforge.blocks.MechanicalGeneratorBlockEntity;
import net.createcobblestone.neoforge.data.GeneratorType;
import net.createcobblestone.neoforge.index.BlockEntities;
import net.createcobblestone.neoforge.index.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class MechanicalGeneratorBlock
extends HorizontalKineticBlock
implements IBE<MechanicalGeneratorBlockEntity> {
    public MechanicalGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferredSide = this.getPreferredHorizontalFacing(context);
        if (preferredSide != null) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)preferredSide);
        }
        return super.getStateForPlacement(context);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public Class<MechanicalGeneratorBlockEntity> getBlockEntityClass() {
        return MechanicalGeneratorBlockEntity.class;
    }

    public BlockEntityType<? extends MechanicalGeneratorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntities.MECHANICAL_GENERATOR.get();
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.SLOW;
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        try {
            GeneratorType type = GeneratorType.fromItem(player.getMainHandItem().getItem());
            if (type.getBlock() == null || type == GeneratorType.NONE || !Config.common().isEnabled(type)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            MechanicalGeneratorBlockEntity be = (MechanicalGeneratorBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
            if (be != null) {
                be.updateType(type);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        catch (NullPointerException ignored) {
            return ItemInteractionResult.FAIL;
        }
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof MechanicalGeneratorBlockEntity) {
            MechanicalGeneratorBlockEntity gen = (MechanicalGeneratorBlockEntity)be;
            gen.type.writeToItemStack(stack);
        }
        return stack;
    }
}

