/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public interface IceBreakable
extends Ability {
    default public void tickIceBreakable() {
        if (this.self().tickCount % 15 == 0) {
            Level level = this.self().getCommandSenderWorld();
            AABB boundingBox = this.self().getBoundingBox().inflate(1.5);
            double offset = 0.75;
            BlockPos start = new BlockPos((int)(boundingBox.minX - offset), (int)(boundingBox.minY - offset), (int)(boundingBox.minZ - offset));
            BlockPos end = new BlockPos((int)(boundingBox.maxX + offset), (int)(boundingBox.maxY + offset), (int)(boundingBox.maxZ + offset));
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            boolean hasBroken = false;
            for (int i = start.getX(); i <= end.getX(); ++i) {
                for (int j = start.getY(); j <= end.getY(); ++j) {
                    for (int k = start.getZ(); k <= end.getZ(); ++k) {
                        pos.set(i, j, k);
                        BlockState blockstate = level.getBlockState((BlockPos)pos);
                        if (!(blockstate.getBlock() instanceof IceBlock)) continue;
                        level.setBlock((BlockPos)pos, Blocks.WATER.defaultBlockState(), 3);
                        hasBroken = true;
                    }
                }
            }
            if (hasBroken) {
                level.playSound(null, (double)start.getX(), (double)start.getY(), (double)start.getZ(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * level.getRandom().nextFloat());
            }
        }
    }
}

