/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.utils;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.joml.Math;
import org.joml.Vector3f;

public class Color {
    private float r;
    private float g;
    private float b;
    private float a = 1.0f;

    public Color(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Color(float r, float g, float b, float a) {
        this(r, g, b);
        this.a = a;
    }

    public Color(int color) {
        this(color, true);
    }

    public Color(int color, boolean alpha) {
        this.set(color, alpha);
    }

    public Color set(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public float getR() {
        return this.r;
    }

    public float getB() {
        return this.b;
    }

    public float getG() {
        return this.g;
    }

    public float getA() {
        return this.a;
    }

    public Vector3f getAsVector3f() {
        return new Vector3f(this.r, this.g, this.b);
    }

    public Color set(float value, int component) {
        switch (component) {
            case 1: {
                this.r = value;
                break;
            }
            case 2: {
                this.g = value;
                break;
            }
            case 3: {
                this.b = value;
                break;
            }
            default: {
                this.a = value;
            }
        }
        return this;
    }

    public Color set(int color) {
        return this.set(color, true);
    }

    public Color set(int color, boolean alpha) {
        this.set((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, alpha ? (float)(color >> 24 & 0xFF) / 255.0f : 1.0f);
        return this;
    }

    public int getRGBAColor() {
        float r = Math.clamp((float)0.0f, (float)1.0f, (float)this.r);
        float g = Math.clamp((float)0.0f, (float)1.0f, (float)this.g);
        float b = Math.clamp((float)0.0f, (float)1.0f, (float)this.b);
        float a = Math.clamp((float)0.0f, (float)1.0f, (float)this.a);
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    public int getRGBColor() {
        return this.getRGBAColor() & 0xFFFFFF;
    }

    public String stringify() {
        return this.stringify(false);
    }

    public String stringify(boolean alpha) {
        if (alpha) {
            return "#" + StringUtils.leftPad((String)Integer.toHexString(this.getRGBAColor()), (int)8, (char)'0');
        }
        return "#" + StringUtils.leftPad((String)Integer.toHexString(this.getRGBColor()), (int)6, (char)'0');
    }

    public boolean equals(Object obj) {
        if (obj instanceof Color) {
            Color color = (Color)obj;
            return color.getRGBAColor() == this.getRGBAColor();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }
}

