/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.mixin.entity;

import com.talhanation.smallships.world.entity.IMixinEntity;
import com.talhanation.smallships.world.entity.cannon.Cannon;
import com.talhanation.smallships.world.entity.projectile.ICannonProjectile;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IMixinEntity,
ICannonProjectile {
    private float prevXRot;
    private float prevYRot;
    @Shadow
    private float xRot;
    @Shadow
    private float yRot;
    @Shadow
    private Level level;
    private boolean preventNextPassengerSyncTeleport;
    private boolean preventDismountingToCoordinates;

    @Shadow
    public abstract void stopRiding();

    @Inject(method={"turn(DD)V"}, at={@At(value="HEAD")})
    public void turn(double x, double y, CallbackInfo ci) {
        this.prevXRot = this.xRot;
        this.prevYRot = this.yRot;
    }

    @Override
    public float getPrevXRot() {
        return this.prevXRot;
    }

    @Override
    public float getPrevYRot() {
        return this.prevYRot;
    }

    @Override
    public void shootAndSpawn(Cannon cannon, Vector3d startPos, Vector3f direction, float cannonSpeedMultiplier, float cannonAccuracy, Entity shooter) {
        if (this.level.isClientSide()) {
            return;
        }
        EntityMixin thisO = this;
        Entity thisEntity = (Entity)thisO;
        this.setPreventTeleportOnNextPassengerSync(true);
        this.setPreventDismountToCoordinates(true);
        this.stopRiding();
        direction.mul(cannonSpeedMultiplier * 3.0f);
        thisEntity.setPos(startPos.x, startPos.y, startPos.z);
        thisEntity.setDeltaMovement((double)direction.x, (double)direction.y, (double)direction.z);
        thisEntity.hasImpulse = true;
        if (thisEntity instanceof Player) {
            Player player = (Player)thisEntity;
            player.startAutoSpinAttack(40, 8.0f, null);
        }
        thisEntity.hurtMarked = true;
    }

    @Override
    public boolean doNotTeleportOnNextPassengerSync() {
        return this.preventNextPassengerSyncTeleport;
    }

    @Override
    public void setPreventTeleportOnNextPassengerSync(boolean prevent) {
        this.preventNextPassengerSyncTeleport = prevent;
    }

    @Override
    public boolean doNotDismountToCoordinates() {
        return this.preventDismountingToCoordinates;
    }

    @Override
    public void setPreventDismountToCoordinates(boolean prevent) {
        this.preventDismountingToCoordinates = prevent;
    }
}

