/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.model;

import com.talhanation.smallships.client.model.ShipModel;
import com.talhanation.smallships.world.entity.ship.CogEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CogModel
extends ShipModel<CogEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"smallships", (String)"cog_model"), "main");
    private final ModelPart root;
    private final ModelPart chest1;
    private final ModelPart chest2;
    private final ModelPart chest3;
    private final ModelPart chest4;
    private final ModelPart steer;

    public CogModel(ModelPart modelPart) {
        this.root = modelPart;
        ModelPart cog = this.root.getChild("Cog");
        this.chest1 = cog.getChild("chest_1");
        this.chest2 = cog.getChild("chest_2");
        this.chest3 = cog.getChild("chest_3");
        this.chest4 = cog.getChild("chest_4");
        this.steer = cog.getChild("steer");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Cog = partdefinition.addOrReplaceChild("Cog", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition deck = Cog.addOrReplaceChild("deck", CubeListBuilder.create(), PartPose.offset((float)14.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = deck.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(28, 0).addBox(28.0f, 0.0f, 2.0f, 14.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(28, 0).addBox(28.0f, -13.0f, 2.0f, 14.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, 0.0f, 2.0f, 28.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(30, 0).addBox(-40.0f, -6.5f, 7.0f, 12.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-13.0f, -16.0f, 2.0f, 13.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-13.0f, 13.0f, 2.0f, 13.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-28.0f, 0.0f, 2.0f, 28.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-28.0f, -13.0f, 2.0f, 28.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, 16.0f, 2.0f, 18.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, -19.0f, 2.0f, 18.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, -16.0f, 2.0f, 28.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-14.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition bottom = Cog.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(4, 1).addBox(42.0f, -11.0f, -3.5f, 4.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = bottom.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(4, 1).addBox(-3.0f, -13.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(4, 1).addBox(-3.0f, -6.5f, -3.5f, 7.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-28.44f, (float)2.4938f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition cube_r3 = bottom.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 0).addBox(38.0f, -2.0f, -10.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(16.0f, -4.0f, -10.0f, 22.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, -4.0f, -10.0f, 22.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-28.0f, -4.0f, -10.0f, 22.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-28.0f, 2.0f, -3.0f, 22.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-28.0f, -12.0f, -3.0f, 22.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, -12.0f, -3.0f, 24.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(18.0f, -12.0f, -3.0f, 24.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, 2.0f, -3.0f, 24.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(18.0f, 2.0f, -3.0f, 24.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition sides = Cog.addOrReplaceChild("sides", CubeListBuilder.create().texOffs(8, 36).addBox(-28.0f, -11.0f, -16.0f, 15.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-13.0f, -11.0f, -19.0f, 14.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(0.0f, -11.0f, -22.0f, 18.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(18.0f, -11.0f, -19.0f, 10.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-28.0f, -11.0f, 13.0f, 15.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-13.0f, -11.0f, 16.0f, 14.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(28.0f, -11.0f, -16.0f, 14.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(28.0f, -17.0f, -16.0f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(37.0f, -17.0f, -16.0f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(28.0f, -17.0f, 13.0f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(37.0f, -17.0f, 13.0f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-35.0f, -16.0f, -6.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-35.0f, -16.0f, 4.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-31.0f, -16.0f, 4.5f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-31.0f, -16.0f, -6.5f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-38.0f, -16.0f, 4.5f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-38.0f, -16.0f, -6.5f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(28.0f, -11.0f, 13.0f, 14.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(0.0f, -11.0f, 19.0f, 18.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(18.0f, -11.0f, 16.0f, 10.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = sides.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(8, 36).addBox(-23.0f, -3.0f, 6.5f, 13.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-6.0f, -8.0f, -75.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-11.0f, -8.0f, -75.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-16.0f, -8.0f, -75.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-23.0f, -9.0f, 6.0f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-1.5f, -9.0f, 6.5f, 5.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-14.0f, -9.0f, 6.5f, 9.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-9.5f, -3.0f, 6.5f, 13.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)35.0f, (float)-8.0f, (float)-9.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r5 = sides.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(8, 36).addBox(3.5f, -3.0f, 6.5f, 13.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 36).addBox(-9.5f, -3.0f, 6.5f, 13.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-20.5f, (float)-8.0f, (float)-3.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition mast_1 = Cog.addOrReplaceChild("mast_1", CubeListBuilder.create().texOffs(8, 0).addBox(-3.0f, -15.0f, -0.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 0).addBox(-3.0f, -30.0f, -0.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 0).addBox(-3.0f, -45.0f, -0.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 0).addBox(-3.0f, -60.0f, -0.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(8, 0).addBox(-3.0f, -75.0f, -0.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)14.0f, (float)-5.0f, (float)-1.0f));
        PartDefinition cube_r6 = mast_1.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(8, 0).addBox(-6.0f, -7.5f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-47.5f, (float)-15.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition mast_oben = Cog.addOrReplaceChild("mast_oben", CubeListBuilder.create().texOffs(0, 0).addBox(9.0f, -69.0f, -16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(9.0f, -69.0f, -32.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(9.0f, -69.0f, 0.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(9.0f, -69.0f, 16.0f, 2.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest_1 = Cog.addOrReplaceChild("chest_1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest_1_r1 = chest_1.addOrReplaceChild("chest_1_r1", CubeListBuilder.create().texOffs(96, 38).addBox(-13.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)37.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r7 = chest_1.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(30, 55).addBox(-0.25f, 3.65f, -0.25f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)27.75f, (float)-11.75f, (float)-8.25f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r8 = chest_1.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(30, 55).addBox(-1.0f, 5.5f, -10.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)19.0f, (float)-15.5f, (float)-18.0f, (float)1.5708f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r9 = chest_1.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(30, 55).addBox(57.0f, -19.0f, 25.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)31.0f, (float)9.0f, (float)-75.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r10 = chest_1.addOrReplaceChild("cube_r10", CubeListBuilder.create(), PartPose.offsetAndRotation((float)22.0f, (float)-9.0f, (float)-1.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition chest_4 = Cog.addOrReplaceChild("chest_4", CubeListBuilder.create(), PartPose.offset((float)-23.0f, (float)-11.5f, (float)9.0f));
        PartDefinition cube_r11 = chest_4.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(64, 29).addBox(-3.0f, -1.5f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r12 = chest_4.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(30, 55).addBox(39.0f, -22.0f, -5.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)20.5f, (float)-42.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r13 = chest_4.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(50, 47).addBox(38.0f, -17.0f, -9.25f, 7.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.5f, (float)-42.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition chest_2 = Cog.addOrReplaceChild("chest_2", CubeListBuilder.create(), PartPose.offset((float)19.0f, (float)-15.5f, (float)15.0f));
        PartDefinition cube_r14 = chest_2.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(30, 55).addBox(0.0f, 6.5f, -10.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r15 = chest_2.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(30, 55).addBox(57.0f, -19.0f, 14.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(30, 55).addBox(32.0f, -25.0f, -8.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.0f, (float)24.5f, (float)-57.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r16 = chest_2.addOrReplaceChild("cube_r16", CubeListBuilder.create(), PartPose.offsetAndRotation((float)3.0f, (float)6.5f, (float)-16.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r16_r1 = cube_r16.addOrReplaceChild("cube_r16_r1", CubeListBuilder.create().texOffs(96, 38).addBox(4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-15.0f, (float)0.0f, (float)7.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition chest_3 = Cog.addOrReplaceChild("chest_3", CubeListBuilder.create(), PartPose.offset((float)51.3333f, (float)-8.0f, (float)-11.1667f));
        PartDefinition cube_r17 = chest_3.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(30, 55).addBox(33.0f, -19.0f, 53.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(31, 56).addBox(33.0f, -19.0f, 49.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-20.3333f, (float)17.0f, (float)-33.8333f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r18 = chest_3.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(96, 38).addBox(-4.0f, -4.0f, -49.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-29.3333f, (float)-1.0f, (float)7.1667f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition steer = Cog.addOrReplaceChild("steer", CubeListBuilder.create().texOffs(4, 1).addBox(0.0f, -7.0f, -1.0f, 4.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)42.0f, (float)9.0f, (float)0.0f));
        PartDefinition BannerStick = Cog.addOrReplaceChild("BannerStick", CubeListBuilder.create().texOffs(8, 0).addBox(12.0f, -94.0f, -0.5f, 1.0f, 15.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(@NotNull CogEntity cogEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.chest1.visible = cogEntity.getInvFillState() >= 15;
        this.chest2.visible = cogEntity.getInvFillState() >= 30;
        this.chest3.visible = cogEntity.getInvFillState() >= 60;
        this.chest4.visible = cogEntity.getInvFillState() >= 90;
        this.steer.yRot = -cogEntity.getRotSpeed() * 0.25f;
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

