/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.turret;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.content.turret.ChemicalTurretBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChemicalTurretBlock
extends KineticBlock
implements IBE<ChemicalTurretBlockEntity>,
ICogWheel {
    public ChemicalTurretBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)ChemicalTurretBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)ChemicalTurretBlock.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChemicalTurretBlockEntity) {
            ChemicalTurretBlockEntity be = (ChemicalTurretBlockEntity)blockEntity;
            be.redstoneSignal = level.getBestNeighborSignal(pos);
        }
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!(state.hasBlockEntity() && state.getBlock() != newState.getBlock() || isMoving || !((blockEntity = level.getBlockEntity(pos)) instanceof ChemicalTurretBlockEntity))) {
            ChemicalTurretBlockEntity be = (ChemicalTurretBlockEntity)blockEntity;
            if (be.lighterUpgrade) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)CDGItems.LIGHTER.asStack());
            }
        }
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChemicalTurretBlockEntity) {
            ChemicalTurretBlockEntity be = (ChemicalTurretBlockEntity)blockEntity;
            if (player.getItemInHand(hand).isEmpty()) {
                if (be.controllingPlayer == player) {
                    be.removePlayer();
                    return ItemInteractionResult.SUCCESS;
                }
                if (be.controllingPlayer == null) {
                    be.setControllingPlayer(player);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if (player.getItemInHand(hand).is((Item)CDGItems.LIGHTER.get()) && !be.lighterUpgrade) {
                be.lighterUpgrade = true;
                if (!level.isClientSide) {
                    be.notifyUpdate();
                }
                if (!player.isCreative()) {
                    player.getItemInHand(hand).shrink(1);
                }
                IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof ChemicalTurretBlockEntity) {
            ChemicalTurretBlockEntity be = (ChemicalTurretBlockEntity)blockEntity;
            if (be.lighterUpgrade) {
                be.lighterUpgrade = false;
                if (!context.getLevel().isClientSide) {
                    be.notifyUpdate();
                }
                if (!context.getPlayer().isCreative()) {
                    context.getPlayer().getInventory().placeItemBackInInventory(CDGItems.LIGHTER.asStack());
                }
                IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
                return InteractionResult.SUCCESS;
            }
        }
        return super.onWrenched(state, context);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChemicalTurretBlockEntity) {
            ChemicalTurretBlockEntity be = (ChemicalTurretBlockEntity)blockEntity;
            be.redstoneSignal = level.getBestNeighborSignal(pos);
        }
        super.neighborChanged(state, level, pos, block, otherPos, isMoving);
    }

    public Class<ChemicalTurretBlockEntity> getBlockEntityClass() {
        return ChemicalTurretBlockEntity.class;
    }

    public BlockEntityType<? extends ChemicalTurretBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.CHEMICAL_TURRET.get();
    }
}

