/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.pumpjack;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.concrete.ConcreteEncasedFluidPipeBlock;
import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class PumpjackHoleBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation {
    BlockState state;
    SmartFluidTankBehaviour tank;
    public int headPos = 0;
    public int bearingPos = 0;
    public boolean started = false;
    public int oilAmount = 0;
    byte tick = 0;
    public int pipeLength = 0;
    boolean valid = false;

    public PumpjackHoleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = state;
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putInt("OilAmount", this.oilAmount);
        tag.putBoolean("Started", this.started);
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.valid) {
            return false;
        }
        Lang.builder((String)"createdieselgenerators").translate("hint.pumpjack_hole_no_pipe.title", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
        MutableComponent hint = Lang.builder((String)"createdieselgenerators").translate("hint.pumpjack_hole_no_pipe", new Object[0]).component();
        List cutComponent = TooltipHelper.cutTextComponent((Component)hint, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
        for (Component component : cutComponent) {
            CreateLang.builder().add(component).forGoggles(tooltip);
        }
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.valid || !this.started) {
            return false;
        }
        if (this.oilAmount == Integer.MAX_VALUE) {
            TooltipHelper.addHint(tooltip, (String)"hint.hose_pulley", (Object[])new Object[0]);
            return true;
        }
        CreateLang.builder().add(Component.translatable((String)"createdieselgenerators.goggle.oil_amount")).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.text((String)String.format("%,d", this.oilAmount)).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).style(ChatFormatting.GOLD).forGoggles(tooltip);
        return true;
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.oilAmount = tag.getInt("OilAmount");
        this.started = tag.getBoolean("Started");
    }

    public void tick() {
        super.tick();
        this.tick = (byte)(this.tick + 1);
        if (this.tick >= 20) {
            int pipeLength = 0;
            this.tick = 0;
            boolean valid = false;
            for (int i = 0; i < this.getBlockPos().getY() - this.level.getMinBuildHeight(); ++i) {
                ++pipeLength;
                BlockState bs = this.level.getBlockState(this.getBlockPos().below(i + 1));
                if (bs.getBlock() instanceof PipeBlock || bs.getBlock() instanceof EncasedPipeBlock || bs.getBlock() instanceof ConcreteEncasedFluidPipeBlock) {
                    if (((Boolean)bs.getValue((Property)BlockStateProperties.UP)).booleanValue() && ((Boolean)bs.getValue((Property)BlockStateProperties.DOWN)).booleanValue()) continue;
                    break;
                }
                if (bs.getBlock() instanceof GlassFluidPipeBlock) {
                    if (bs.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y) continue;
                    break;
                }
                if (bs.is(AllTags.optionalTag((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)CreateDieselGenerators.rl("pumpjack_pipe")))) continue;
                if (!bs.is(AllTags.optionalTag((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)CreateDieselGenerators.rl("oil_deposit")))) break;
                valid = true;
                break;
            }
            this.pipeLength = valid ? pipeLength : 0;
            this.valid = valid;
        }
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().inflate((double)this.pipeLength);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)8000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void pumpjackRotation(boolean isCrankLarge) {
        ArrayList stackList = new ArrayList();
        BuiltInRegistries.FLUID.getTags().filter(p -> ((TagKey)p.getFirst()).equals((Object)AllTags.optionalTag((Registry)BuiltInRegistries.FLUID, (ResourceLocation)CreateDieselGenerators.rl("pumpjack_output")))).map(Pair::getSecond).forEach(s -> stackList.addAll(s.stream().map(Holder::value).toList()));
        if (stackList.isEmpty()) {
            return;
        }
        if (!this.level.isClientSide && this.valid) {
            ChunkPos chunkPos = new ChunkPos(this.getBlockPos());
            this.oilAmount = OilChunksSavedData.getChunkOilAmount((ServerLevel)this.level, chunkPos);
            this.started = true;
            int subtractedAmount = Mth.clamp((int)((int)(1000.0f * Math.abs((float)this.headPos / (float)this.bearingPos)) * (isCrankLarge ? 2 : 1)), (int)0, (int)this.oilAmount);
            FluidStack oilStack = new FluidStack((Fluid)stackList.get(0), subtractedAmount);
            subtractedAmount = this.tank.getPrimaryHandler().fill(oilStack, IFluidHandler.FluidAction.EXECUTE);
            if (this.oilAmount == Integer.MAX_VALUE) {
                return;
            }
            this.oilAmount -= subtractedAmount;
            OilChunksSavedData.setChunkOilAmount((ServerLevel)this.level, chunkPos, this.oilAmount);
        }
        if (this.level.isClientSide && this.oilAmount > 0) {
            FluidFX.spawnPouringLiquid((Level)this.level, (BlockPos)this.worldPosition, (int)20, (ParticleOptions)FluidFX.getFluidParticle((FluidStack)new FluidStack((Fluid)stackList.get(0), 1000)), (float)0.3f, (Vec3)new Vec3(0.1, 1.0, 0.1), (boolean)true);
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.PUMPJACK_HOLE.get(), (be, side) -> {
            if (side == null || side.getAxis().isHorizontal() && ((Boolean)be.getBlockState().getValue((Property)(side == Direction.NORTH ? BlockStateProperties.NORTH : (side == Direction.EAST ? BlockStateProperties.EAST : (side == Direction.WEST ? BlockStateProperties.WEST : BlockStateProperties.SOUTH))))).booleanValue()) {
                return be.tank.getCapability();
            }
            return null;
        });
    }
}

