/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.distillation;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.content.distillation.DistillationTankBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import java.util.ArrayList;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class DistillationTankBlock
extends Block
implements IBE<DistillationTankBlockEntity>,
IWrenchable,
SpecialBlockItemRequirement {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final EnumProperty<FluidTankBlock.Shape> SHAPE = EnumProperty.create((String)"shape", FluidTankBlock.Shape.class);

    public DistillationTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isTank(BlockState state) {
        return state.getBlock() instanceof DistillationTankBlock;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof DistillationTankBlockEntity) {
            BlockEntity z2;
            DistillationTankBlockEntity dtbe = (DistillationTankBlockEntity)blockEntity;
            int width = dtbe.getControllerBE().getWidth();
            BlockPos pos = dtbe.getController();
            IFluidHandler tank = (IFluidHandler)context.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, dtbe.getBlockPos(), null);
            FluidStack stackInTank = tank == null ? FluidStack.EMPTY : tank.getFluidInTank(0);
            for (int x = 0; x < width; ++x) {
                for (int z2 = 0; z2 < width; ++z2) {
                    context.getLevel().setBlockAndUpdate(pos.offset(x, 0, z2), AllBlocks.FLUID_TANK.getDefaultState());
                    context.getLevel().updateNeighborsAt(pos.offset(x, 0, z2), (Block)AllBlocks.FLUID_TANK.get());
                    if (!context.getLevel().isClientSide) continue;
                    for (int i = 0; i < 30; ++i) {
                        Vec3 offset = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)pos.offset(x, 0, z2)), (RandomSource)context.getLevel().getRandom(), (float)0.3f);
                        Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)context.getLevel().getRandom(), (float)0.1f);
                        context.getLevel().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, CDGItems.DISTILLATION_CONTROLLER.asStack()), offset.x(), offset.y(), offset.z(), motion.x(), motion.y(), motion.z());
                    }
                }
            }
            AllSoundEvents.WRENCH_REMOVE.playAt(context.getLevel(), (double)pos.getX() + (double)width / 2.0, (double)pos.getY() + 0.5, (double)pos.getZ() + (double)width / 2.0, 2.0f, 1.0f, false);
            if (!stackInTank.isEmpty() && (z2 = context.getLevel().getBlockEntity(pos)) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity be = (FluidTankBlockEntity)z2;
                IFluidHandler fTank = (IFluidHandler)context.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), null);
                if (fTank != null) {
                    fTank.fill(stackInTank, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            if (!context.getPlayer().isCreative()) {
                context.getPlayer().getInventory().placeItemBackInInventory(CDGItems.DISTILLATION_CONTROLLER.asStack(width * width));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        if (direction == Direction.DOWN && neighbourState.getBlock() != this) {
            this.withBlockEntityDo((BlockGetter)level, pos, DistillationTankBlockEntity::updateTemperature);
        }
        return super.updateShape(state, direction, neighbourState, level, pos, neighbourPos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean p_60514_) {
        super.neighborChanged(state, level, pos, block, otherPos, p_60514_);
        this.withBlockEntityDo((BlockGetter)level, pos, DistillationTankBlockEntity::updateVerticalMulti);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOP, BOTTOM, SHAPE});
    }

    public Class<DistillationTankBlockEntity> getBlockEntityClass() {
        return DistillationTankBlockEntity.class;
    }

    public BlockEntityType<? extends DistillationTankBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.DISTILLATION_TANK.get();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), DistillationTankBlockEntity::toggleWindows);
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof DistillationTankBlockEntity)) {
                return;
            }
            DistillationTankBlockEntity tankBE = (DistillationTankBlockEntity)be;
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return AllBlocks.FLUID_TANK.asStack();
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, DistillationTankBlockEntity::updateConnectivity);
        this.withBlockEntityDo((BlockGetter)level, pos, DistillationTankBlockEntity::updateVerticalMulti);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean x = mirror == Mirror.FRONT_BACK;
        return switch ((FluidTankBlock.Shape)state.getValue(SHAPE)) {
            case FluidTankBlock.Shape.WINDOW_NE -> (BlockState)state.setValue(SHAPE, (Comparable)(x ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SE));
            case FluidTankBlock.Shape.WINDOW_NW -> (BlockState)state.setValue(SHAPE, (Comparable)(x ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SW));
            case FluidTankBlock.Shape.WINDOW_SE -> (BlockState)state.setValue(SHAPE, (Comparable)(x ? FluidTankBlock.Shape.WINDOW_SW : FluidTankBlock.Shape.WINDOW_NE));
            case FluidTankBlock.Shape.WINDOW_SW -> (BlockState)state.setValue(SHAPE, (Comparable)(x ? FluidTankBlock.Shape.WINDOW_SE : FluidTankBlock.Shape.WINDOW_NW));
            default -> state;
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        return switch ((FluidTankBlock.Shape)state.getValue(SHAPE)) {
            case FluidTankBlock.Shape.WINDOW_NE -> (BlockState)state.setValue(SHAPE, (Comparable)FluidTankBlock.Shape.WINDOW_SE);
            case FluidTankBlock.Shape.WINDOW_NW -> (BlockState)state.setValue(SHAPE, (Comparable)FluidTankBlock.Shape.WINDOW_NE);
            case FluidTankBlock.Shape.WINDOW_SE -> (BlockState)state.setValue(SHAPE, (Comparable)FluidTankBlock.Shape.WINDOW_SW);
            case FluidTankBlock.Shape.WINDOW_SW -> (BlockState)state.setValue(SHAPE, (Comparable)FluidTankBlock.Shape.WINDOW_NW);
            default -> state;
        };
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(AllBlocks.FLUID_TANK.asStack());
        list.add(CDGItems.DISTILLATION_CONTROLLER.asStack());
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, list);
    }
}

