/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.canister;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.tools.FueledToolItem;
import com.simibubi.create.AllEnchantments;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;

public class CanisterBlockItem
extends BlockItem
implements FueledToolItem {
    public CanisterBlockItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        this.createTooltip(tooltipComponents, stack);
    }

    @Override
    public int getBaseCapacity(ItemStack stack) {
        return (Integer)CDGConfig.CANISTER_CAPACITY.get();
    }

    @Override
    public int getCapacityEnchantmentAddition(ItemStack stack) {
        return (Integer)CDGConfig.CANISTER_CAPACITY_ENCHANTMENT.get();
    }

    public InteractionResult useOn(UseOnContext p_40581_) {
        return super.useOn(p_40581_);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (AllEnchantments.CAPACITY.equals(enchantment.getKey())) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public int getBarColor(ItemStack stack) {
        return 0xEFEFEF;
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getCurrentFillLevel(stack) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)this.getCurrentFillLevel(stack) / (float)this.getCapacity(stack));
    }
}

