/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.function.Function;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.state.BlockState;

public enum StandingOrWallType implements StringRepresentable
{
    NONE(blockItem -> blockItem.getBlock().defaultBlockState()),
    STANDING(blockItem -> blockItem.wallBlock.defaultBlockState()),
    WALL(blockItem -> blockItem.getBlock().defaultBlockState());

    private final Function<StandingAndWallBlockItem, BlockState> newState;

    private StandingOrWallType(Function<StandingAndWallBlockItem, BlockState> newState) {
        this.newState = newState;
    }

    public BlockState getNewState(StandingAndWallBlockItem blockItem) {
        return this.newState.apply(blockItem);
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }
}

