/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.function.IntFunction;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ToggleComponentButton
extends Button
implements IToggleableButton {
    private final IntFunction<Component> onValueChange;
    private int currentIndex = 0;
    private final int toggleCount;

    public ToggleComponentButton(int xPos, int yPos, int width, int height, IntFunction<Component> onValueChange, int initialValue, int toggleCount, Button.OnPress onPress) {
        super(xPos, yPos, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.onValueChange = onValueChange;
        this.currentIndex = initialValue;
        this.toggleCount = toggleCount;
        this.onValueChange();
    }

    public void onClick(double mouseX, double mouseY) {
        if (Screen.hasShiftDown()) {
            this.cycleIndex(-1);
        } else {
            this.cycleIndex(1);
        }
        super.onClick(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.clicked(mouseX, mouseY)) {
            this.cycleIndex(-((int)Math.signum(scrollY)));
            this.onPress();
            return true;
        }
        return false;
    }

    public void cycleIndex(int value) {
        this.setCurrentIndex(Math.floorMod(this.currentIndex + value, this.toggleCount));
        this.onValueChange();
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int newIndex) {
        this.currentIndex = Math.floorMod(newIndex, this.toggleCount);
    }

    public void onValueChange() {
        this.setMessage(this.onValueChange.apply(this.currentIndex));
    }
}

