/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.level.Level;

public abstract class CombineRecipe
extends CustomRecipe {
    protected CombineRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput inv, Level level) {
        ItemStack firstItem = ItemStack.EMPTY;
        ItemStack secondItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (this.matchesFirstItem(stack)) {
                if (firstItem.isEmpty()) {
                    firstItem = stack;
                    continue;
                }
                return false;
            }
            if (this.matchesSecondItem(stack)) {
                if (secondItem.isEmpty()) {
                    secondItem = stack;
                    continue;
                }
                return false;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return this.canBeCombined(firstItem, secondItem);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider lookupProvider) {
        ItemStack firstItem = ItemStack.EMPTY;
        ItemStack secondItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (this.matchesFirstItem(stack)) {
                firstItem = stack;
                continue;
            }
            if (!this.matchesSecondItem(stack)) continue;
            secondItem = stack;
        }
        return this.combine(firstItem, secondItem);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public abstract boolean matchesFirstItem(ItemStack var1);

    public abstract boolean matchesSecondItem(ItemStack var1);

    public boolean canBeCombined(ItemStack firstItem, ItemStack secondItem) {
        return !firstItem.isEmpty() && !secondItem.isEmpty();
    }

    public abstract ItemStack combine(ItemStack var1, ItemStack var2);
}

