/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.fluids;

import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.FakeLavaBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class FakeLavaFluid
extends BaseFlowingFluid {
    protected FakeLavaFluid(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    public Fluid getFlowing() {
        return (Fluid)SCContent.FLOWING_FAKE_LAVA.get();
    }

    public Fluid getSource() {
        return (Fluid)SCContent.FAKE_LAVA.get();
    }

    public Item getBucket() {
        return (Item)SCContent.FAKE_LAVA_BUCKET.get();
    }

    public void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos posAbove = pos.above();
        if (level.getBlockState(posAbove).isAir() && !level.getBlockState(posAbove).isSolidRender((BlockGetter)level, posAbove)) {
            if (random.nextInt(100) == 0) {
                double x = (float)pos.getX() + random.nextFloat();
                double y = pos.getY() + 1;
                double z = (float)pos.getZ() + random.nextFloat();
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0);
                level.playLocalSound(x, y, z, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public void randomTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
        block7: {
            if (!level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos posToUpdate = pos;
                for (int j = 0; j < i; ++j) {
                    if (!level.isLoaded(posToUpdate = posToUpdate.offset(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState stateToUpdate = level.getBlockState(posToUpdate);
                    if (stateToUpdate.isAir()) {
                        if (!this.isSurroundingBlockFlammable(level, posToUpdate)) continue;
                        level.setBlockAndUpdate(posToUpdate, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)posToUpdate, (BlockPos)pos, (BlockState)Blocks.FIRE.defaultBlockState()));
                        return;
                    }
                    if (!stateToUpdate.blocksMotion()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos posToUpdate = pos.offset(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!level.isLoaded(posToUpdate)) {
                        return;
                    }
                    BlockPos posAbove = posToUpdate.above();
                    if (!level.isEmptyBlock(posAbove) || !this.isFlammable((LevelReader)level, posToUpdate, Direction.UP)) continue;
                    level.setBlockAndUpdate(posAbove, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)posAbove, (BlockPos)pos, (BlockState)Blocks.FIRE.defaultBlockState()));
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.isFlammable((LevelReader)level, pos.relative(direction), direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable(LevelReader level, BlockPos pos, Direction face) {
        if (pos.getY() >= level.getMinBuildHeight() && pos.getY() < level.getMaxBuildHeight() && !level.hasChunkAt(pos)) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        return state.ignitedByLava() && state.isFlammable((BlockGetter)level, pos, face);
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_LAVA;
    }

    protected boolean canConvertToSource(Level level) {
        return level.getGameRules().getBoolean(SecurityCraft.RULE_FAKE_LAVA_SOURCE_CONVERSION.get());
    }

    public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return this.canConvertToSource(level);
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        this.triggerEffects(level, pos);
    }

    public int getSlopeFindDistance(LevelReader level) {
        return level.dimensionType().ultraWarm() ? 4 : 2;
    }

    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)((FakeLavaBlock)((Object)SCContent.FAKE_LAVA_BLOCK.get())).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(FakeLavaFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSame(Fluid fluid) {
        return fluid == SCContent.FAKE_LAVA.get() || fluid == SCContent.FLOWING_FAKE_LAVA.get();
    }

    public int getDropOff(LevelReader level) {
        return level.dimensionType().ultraWarm() ? 1 : 2;
    }

    public boolean canBeReplacedWith(FluidState fluidState, BlockGetter level, BlockPos pos, Fluid fluid, Direction dir) {
        return fluidState.getHeight(level, pos) >= 0.44444445f && fluid.is(FluidTags.WATER);
    }

    public int getTickDelay(LevelReader level) {
        return level.dimensionType().ultraWarm() ? 10 : 30;
    }

    public int getSpreadDelay(Level level, BlockPos pos, FluidState currentState, FluidState newState) {
        int tickDelay = this.getTickDelay((LevelReader)level);
        if (!(currentState.isEmpty() || newState.isEmpty() || ((Boolean)currentState.getValue((Property)FALLING)).booleanValue() || ((Boolean)newState.getValue((Property)FALLING)).booleanValue() || !(newState.getHeight((BlockGetter)level, pos) > currentState.getHeight((BlockGetter)level, pos)) || level.getRandom().nextInt(4) == 0)) {
            tickDelay *= 4;
        }
        return tickDelay;
    }

    protected void triggerEffects(LevelAccessor level, BlockPos pos) {
        level.levelEvent(1501, pos, 0);
    }

    protected void spreadTo(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        if (direction == Direction.DOWN && this.is(FluidTags.LAVA) && fluidState.is(FluidTags.WATER)) {
            if (state.getBlock() instanceof LiquidBlock) {
                level.setBlock(pos, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (BlockState)Blocks.STONE.defaultBlockState()), 3);
            }
            this.triggerEffects(level, pos);
            return;
        }
        super.spreadTo(level, pos, state, direction, fluidState);
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public static class Source
    extends FakeLavaFluid {
        public Source(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FakeLavaFluid {
        public Flowing(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

