/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.function.BiConsumer;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class OwnableFenceGateBlock
extends FenceGateBlock
implements EntityBlock {
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public OwnableFenceGateBlock(BlockBehaviour.Properties properties, WoodType woodType) {
        super(woodType, OwnableBlock.withReinforcedDestroyTime(properties));
    }

    public OwnableFenceGateBlock(BlockBehaviour.Properties properties, SoundEvent openSound, SoundEvent closeSound) {
        super(OwnableBlock.withReinforcedDestroyTime(properties), openSound, closeSound);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public void onExplosionHit(BlockState state, Level level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        if (!explosion.canTriggerBlocks()) {
            super.onExplosionHit(state, level, pos, explosion, dropConsumer);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(context.getLevel(), context.getClickedPos());
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasActiveSCBlock));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            boolean isPoweredSCBlock = BlockUtils.hasActiveSCBlockNextTo(level, pos);
            if ((Boolean)state.getValue((Property)POWERED) != isPoweredSCBlock) {
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPoweredSCBlock))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(isPoweredSCBlock)), 2);
                if ((Boolean)state.getValue((Property)OPEN) != isPoweredSCBlock) {
                    level.playSound(null, pos, isPoweredSCBlock ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                    level.gameEvent(null, (Holder)(isPoweredSCBlock ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
                }
            }
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }
}

