/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

public abstract class SpecialDoorBlockEntity
extends LinkableBlockEntity
implements ILockable {
    protected Option.IntOption signalLength = new Option.IntOption("signalLength", this.defaultSignalLength(), 0, 400, 5);
    protected Option.DisabledOption disabled = new Option.DisabledOption(false);

    protected SpecialDoorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        SpecialDoorBlockEntity be;
        pos = state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos.above();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SpecialDoorBlockEntity && SpecialDoorBlockEntity.isLinkedWith(this, be = (SpecialDoorBlockEntity)blockEntity)) {
            be.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!level.isClientSide) {
                level.getServer().getPlayerList().broadcastAll((Packet)be.getUpdatePacket());
            }
        }
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
        ILinkedAction iLinkedAction = action;
        Objects.requireNonNull(iLinkedAction);
        ILinkedAction iLinkedAction2 = iLinkedAction;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ILinkedAction.OptionChanged.class, ILinkedAction.ModuleInserted.class, ILinkedAction.ModuleRemoved.class}, (Object)iLinkedAction2, n)) {
            case 0: {
                Option[] option;
                ILinkedAction.OptionChanged optionChanged = (ILinkedAction.OptionChanged)iLinkedAction2;
                try {
                    Option[] optionArray;
                    option = optionArray = optionChanged.option();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                for (Option customOption : this.customOptions()) {
                    if (!customOption.getName().equals(option.getName())) continue;
                    customOption.copy((Option<?>)option);
                    break;
                }
                this.setChanged();
                return;
            }
            case 1: {
                boolean wasModuleToggled;
                ItemStack stack;
                ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)iLinkedAction2;
                {
                    boolean bl;
                    Object object;
                    stack = object = moduleInserted.stack();
                    Object module = object = moduleInserted.module();
                    wasModuleToggled = bl = moduleInserted.wasModuleToggled();
                }
                this.insertModule(stack, wasModuleToggled);
                return;
            }
            case 2: {
                boolean wasModuleToggled;
                ModuleType moduleType2;
                ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)iLinkedAction2;
                {
                    boolean bl;
                    ModuleType moduleType;
                    moduleType2 = moduleType = moduleRemoved.moduleType();
                    wasModuleToggled = bl = moduleRemoved.wasModuleToggled();
                }
                this.removeModule(moduleType2, wasModuleToggled);
                return;
            }
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted(this, stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved(this, stack, toggled);
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, packet, lookupProvider);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public void setRemoved() {
        super.setRemoved();
        DisguisableBlockEntity.onSetRemoved(this);
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData(this);
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public abstract int defaultSignalLength();
}

