/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface IViewActivated {
    default public void checkView(Level level, BlockPos pos) {
        if (this.getViewCooldown() > 0) {
            this.setViewCooldown(this.getViewCooldown() - 1);
            return;
        }
        double maximumDistance = this.getMaximumDistance();
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(maximumDistance), e -> e.canBeSeenByAnyone() && !this.isConsideredInvisible((LivingEntity)e) && (!this.activatedOnlyByPlayer() || e instanceof Player));
        for (LivingEntity entity : entities) {
            double eyeHeight = entity.getEyeHeight();
            Vec3 lookVec = new Vec3(entity.getX() + entity.getLookAngle().x * maximumDistance, eyeHeight + entity.getY() + entity.getLookAngle().y * maximumDistance, entity.getZ() + entity.getLookAngle().z * maximumDistance);
            BlockHitResult hitResult = level.clip(new ClipContext(new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
            if (hitResult == null || hitResult.getBlockPos().getX() != pos.getX() || hitResult.getBlockPos().getY() != pos.getY() || hitResult.getBlockPos().getZ() != pos.getZ() || !this.onEntityViewed(entity, hitResult)) continue;
            this.setViewCooldown(this.getDefaultViewCooldown());
        }
    }

    default public int getDefaultViewCooldown() {
        return 30;
    }

    public int getViewCooldown();

    public void setViewCooldown(int var1);

    public boolean onEntityViewed(LivingEntity var1, BlockHitResult var2);

    default public boolean activatedOnlyByPlayer() {
        return true;
    }

    public double getMaximumDistance();

    public boolean isConsideredInvisible(LivingEntity var1);
}

