/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.registries;

import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import fr.iglee42.createcasing.CreateCasing;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.resources.ResourceLocation;

public class EncasedSprites {
    public static final CTSpriteShiftEntry RAILWAY_ENCASED_COGWHEEL_SIDE;
    public static final CTSpriteShiftEntry RAILWAY_ENCASED_COGWHEEL_OTHERSIDE;
    public static final CTSpriteShiftEntry COPPER_ENCASED_COGWHEEL_SIDE;
    public static final CTSpriteShiftEntry COPPER_ENCASED_COGWHEEL_OTHERSIDE;
    public static final CTSpriteShiftEntry SHADOW_STEEL_ENCASED_COGWHEEL_SIDE;
    public static final CTSpriteShiftEntry SHADOW_STEEL_ENCASED_COGWHEEL_OTHERSIDE;
    public static final CTSpriteShiftEntry REFINED_RADIANCE_ENCASED_COGWHEEL_SIDE;
    public static final CTSpriteShiftEntry REFINED_RADIANCE_ENCASED_COGWHEEL_OTHERSIDE;
    public static final CTSpriteShiftEntry CREATIVE_ENCASED_COGWHEEL_SIDE;
    public static final CTSpriteShiftEntry CREATIVE_ENCASED_COGWHEEL_OTHERSIDE;
    public static final SpriteShiftEntry COPPER_BELT_CASING;
    public static final SpriteShiftEntry RAILWAY_BELT_CASING;
    public static final SpriteShiftEntry INDUSTRIAL_IRON_BELT_CASING;
    public static final SpriteShiftEntry WEATHERED_IRON_BELT_CASING;
    public static final SpriteShiftEntry CREATIVE_BELT_CASING;
    public static final SpriteShiftEntry REFINED_RADIANCE_BELT_CASING;
    public static final SpriteShiftEntry SHADOW_STEEL_BELT_CASING;
    public static final SpriteShiftEntry INDUSTRIAL_IRON;
    public static final SpriteShiftEntry WEATHERED_IRON;

    private static CTSpriteShiftEntry horizontal(String name) {
        return EncasedSprites.getCT((CTType)AllCTTypes.HORIZONTAL, name);
    }

    private static CTSpriteShiftEntry vertical(String name) {
        return EncasedSprites.getCT((CTType)AllCTTypes.VERTICAL, name);
    }

    private static CTSpriteShiftEntry omni(String name) {
        return EncasedSprites.getCT((CTType)AllCTTypes.OMNIDIRECTIONAL, name);
    }

    private static SpriteShiftEntry get(String originalLocation, String targetLocation) {
        return EncasedSprites.get(CreateCasing.asResource(originalLocation), CreateCasing.asResource(targetLocation));
    }

    private static SpriteShiftEntry getFromCreate(String originalLocation, String targetLocation) {
        return EncasedSprites.get(Create.asResource((String)originalLocation), CreateCasing.asResource(targetLocation));
    }

    private static SpriteShiftEntry getFromCreate(String location) {
        return EncasedSprites.get(Create.asResource((String)location), CreateCasing.asResource(location));
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName, String connectedTextureName) {
        return EncasedSprites.getCT(type, CreateCasing.asResource("block/" + blockTextureName), CreateCasing.asResource("block/" + connectedTextureName + "_connected"));
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName) {
        return EncasedSprites.getCT(type, blockTextureName, blockTextureName);
    }

    public static CTSpriteShiftEntry getEntryForCasing(String casing) {
        return switch (casing) {
            case "andesite" -> AllSpriteShifts.ANDESITE_CASING;
            case "brass" -> AllSpriteShifts.BRASS_CASING;
            case "copper" -> AllSpriteShifts.COPPER_CASING;
            case "railway" -> AllSpriteShifts.RAILWAY_CASING;
            case "creative" -> AllSpriteShifts.CREATIVE_CASING;
            case "shadow_steel" -> AllSpriteShifts.SHADOW_STEEL_CASING;
            case "refined_radiance" -> AllSpriteShifts.REFINED_RADIANCE_CASING;
            default -> null;
        };
    }

    public static CTSpriteShiftEntry getEntryForSide(String casing) {
        return switch (casing) {
            case "andesite" -> AllSpriteShifts.ANDESITE_ENCASED_COGWHEEL_SIDE;
            case "brass" -> AllSpriteShifts.BRASS_ENCASED_COGWHEEL_SIDE;
            case "copper" -> COPPER_ENCASED_COGWHEEL_SIDE;
            case "railway" -> RAILWAY_ENCASED_COGWHEEL_SIDE;
            case "creative" -> CREATIVE_ENCASED_COGWHEEL_SIDE;
            case "shadow_steel" -> SHADOW_STEEL_ENCASED_COGWHEEL_SIDE;
            case "refined_radiance" -> REFINED_RADIANCE_ENCASED_COGWHEEL_SIDE;
            default -> null;
        };
    }

    public static CTSpriteShiftEntry getEntryForOtherSide(String casing) {
        return switch (casing) {
            case "andesite" -> AllSpriteShifts.ANDESITE_ENCASED_COGWHEEL_OTHERSIDE;
            case "brass" -> AllSpriteShifts.BRASS_ENCASED_COGWHEEL_OTHERSIDE;
            case "copper" -> COPPER_ENCASED_COGWHEEL_OTHERSIDE;
            case "railway" -> RAILWAY_ENCASED_COGWHEEL_OTHERSIDE;
            case "creative" -> CREATIVE_ENCASED_COGWHEEL_OTHERSIDE;
            case "shadow_steel" -> SHADOW_STEEL_ENCASED_COGWHEEL_OTHERSIDE;
            case "refined_radiance" -> REFINED_RADIANCE_ENCASED_COGWHEEL_OTHERSIDE;
            default -> null;
        };
    }

    private static CTSpriteShiftEntry getCT(CTType type, ResourceLocation blockTexture, ResourceLocation connectedTexture) {
        CTSpriteShiftEntry entry = new CTSpriteShiftEntry(type);
        if (CatnipServices.PLATFORM.getEnv().isClient()) {
            entry.set(blockTexture, connectedTexture);
        }
        return entry;
    }

    public static SpriteShiftEntry get(ResourceLocation originalLocation, ResourceLocation targetLocation) {
        SpriteShiftEntry entry = new SpriteShiftEntry();
        CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> entry.set(originalLocation, targetLocation));
        return entry;
    }

    static {
        COPPER_BELT_CASING = EncasedSprites.getFromCreate("block/belt/brass_belt_casing", "block/belt_casing/copper");
        RAILWAY_BELT_CASING = EncasedSprites.getFromCreate("block/belt/brass_belt_casing", "block/belt_casing/railway");
        INDUSTRIAL_IRON_BELT_CASING = EncasedSprites.getFromCreate("block/belt/brass_belt_casing", "block/belt_casing/industrial_iron");
        WEATHERED_IRON_BELT_CASING = EncasedSprites.getFromCreate("block/belt/brass_belt_casing", "block/belt_casing/weathered_iron");
        CREATIVE_BELT_CASING = EncasedSprites.getFromCreate("block/belt/brass_belt_casing", "block/belt_casing/creative");
        REFINED_RADIANCE_BELT_CASING = EncasedSprites.getFromCreate("block/belt/brass_belt_casing", "block/belt_casing/refined_radiance");
        SHADOW_STEEL_BELT_CASING = EncasedSprites.getFromCreate("block/belt/brass_belt_casing", "block/belt_casing/shadow_steel");
        INDUSTRIAL_IRON = EncasedSprites.getFromCreate("block/industrial_iron_block");
        WEATHERED_IRON = EncasedSprites.getFromCreate("block/weathered_iron_block");
        RAILWAY_ENCASED_COGWHEEL_SIDE = EncasedSprites.vertical("encased_cogwheel/railway");
        RAILWAY_ENCASED_COGWHEEL_OTHERSIDE = EncasedSprites.horizontal("encased_cogwheel/railway");
        COPPER_ENCASED_COGWHEEL_SIDE = EncasedSprites.vertical("encased_cogwheel/copper");
        COPPER_ENCASED_COGWHEEL_OTHERSIDE = EncasedSprites.horizontal("encased_cogwheel/copper");
        SHADOW_STEEL_ENCASED_COGWHEEL_SIDE = EncasedSprites.vertical("encased_cogwheel/shadow");
        SHADOW_STEEL_ENCASED_COGWHEEL_OTHERSIDE = EncasedSprites.horizontal("encased_cogwheel/shadow");
        REFINED_RADIANCE_ENCASED_COGWHEEL_SIDE = EncasedSprites.vertical("encased_cogwheel/radiance");
        REFINED_RADIANCE_ENCASED_COGWHEEL_OTHERSIDE = EncasedSprites.horizontal("encased_cogwheel/radiance");
        CREATIVE_ENCASED_COGWHEEL_SIDE = EncasedSprites.vertical("encased_cogwheel/creative");
        CREATIVE_ENCASED_COGWHEEL_OTHERSIDE = EncasedSprites.horizontal("encased_cogwheel/creative");
    }
}

