/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.registries;

import com.google.common.base.Supplier;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.foundation.data.recipe.CommonMetal;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import fr.iglee42.createcasing.CreateCasing;
import fr.iglee42.createcasing.casings.CasingSet;
import fr.iglee42.createcasing.casings.CasingSets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;

public class EncasedRecipeGens
extends BaseRecipeProvider {
    final List<BaseRecipeProvider.GeneratedRecipe> all = new ArrayList<BaseRecipeProvider.GeneratedRecipe>();
    String currentFolder = "";
    String lastFolder = "";

    void enterFolder(String folder) {
        this.currentFolder = this.currentFolder + (this.currentFolder.isEmpty() ? "" : "/") + folder;
        this.lastFolder = folder;
    }

    void leftLastFolder() {
        this.currentFolder = this.currentFolder.substring(0, this.currentFolder.length() - ("/" + this.lastFolder).length());
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder("", result);
    }

    GeneratedRecipeBuilder create(String path, Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder + "/" + path, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    BaseRecipeProvider.GeneratedRecipe createSpecial(Function<CraftingBookCategory, Recipe<?>> builder, String recipeType, String path) {
        ResourceLocation location = CreateCasing.asResource(recipeType + "/" + this.currentFolder + "/" + path);
        return this.register(consumer -> {
            SpecialRecipeBuilder b = SpecialRecipeBuilder.special((Function)builder);
            b.save(consumer, location.toString());
        });
    }

    public void buildRecipes(RecipeOutput output) {
        this.all.forEach(c -> c.register(output));
        CreateCasing.LOGGER.info("{} registered {} recipe{}", new Object[]{this.getName(), this.all.size(), this.all.size() == 1 ? "" : "s"});
    }

    protected BaseRecipeProvider.GeneratedRecipe register(BaseRecipeProvider.GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    public EncasedRecipeGens(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "createcasing");
        this.enterFolder("crafting");
        this.createForSetElement("adjustable_chain_drive", CasingSet::doesGenerateChainGearshift, CasingSet::getChainGearshift, (builder, set) -> builder.viaShapeless(sh -> sh.requires((ItemLike)set.getChainDrive()).requires((ItemLike)AllItems.ELECTRON_TUBE)));
        this.createForSetElement("chain_conveyor", CasingSet::doesGenerateChainConveyor, CasingSet::getChainConveyor, (builder, set) -> builder.viaShaped(sh -> sh.pattern(" C ").pattern("CAC").pattern(" C ").define(Character.valueOf('A'), (ItemLike)AllBlocks.LARGE_COGWHEEL).define(Character.valueOf('C'), (ItemLike)set.getCasing())));
        this.createForSetElement("chain_drive", CasingSet::doesGenerateChainDrive, CasingSet::getChainDrive, (builder, set) -> builder.viaShapeless(sh -> sh.requires((ItemLike)set.getCasing()).requires(Tags.Items.NUGGETS_IRON).requires(Tags.Items.NUGGETS_IRON).requires(Tags.Items.NUGGETS_IRON)));
        this.createForSetElement("clutch", CasingSet::doesGenerateClutch, CasingSet::getClutch, (builder, set) -> builder.viaShapeless(sh -> sh.requires((ItemLike)set.getCasing()).requires((ItemLike)AllBlocks.SHAFT).requires(Tags.Items.DUSTS_REDSTONE)));
        this.createForSetElement("configurable_gearbox", CasingSet::doesGenerateConfigurableGearbox, CasingSet::getConfigurableGearbox, (builder, set) -> builder.viaShaped(sh -> sh.pattern(" C ").pattern("CAC").pattern(" C ").define(Character.valueOf('C'), (ItemLike)AllBlocks.LARGE_COGWHEEL).define(Character.valueOf('A'), (ItemLike)set.getCasing())));
        this.createForSetElement("deployer", CasingSet::doesGenerateDeployer, CasingSet::getDeployer, (builder, set) -> builder.viaShaped(sh -> sh.pattern("B").pattern("C").pattern("I").define(Character.valueOf('B'), (ItemLike)AllItems.ELECTRON_TUBE).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), (ItemLike)AllItems.BRASS_HAND)));
        this.createForSetElement("depot", CasingSet::doesGenerateDepot, CasingSet::getDepot, (builder, set) -> builder.viaShapeless(sh -> sh.requires((ItemLike)AllItems.ANDESITE_ALLOY).requires((ItemLike)set.getCasing())));
        this.createForSetElement("encased_fan", CasingSet::doesGenerateEncasedFan, CasingSet::getEncasedFan, (builder, set) -> builder.viaShaped(sh -> sh.pattern("B").pattern("C").pattern("I").define(Character.valueOf('B'), (ItemLike)AllBlocks.SHAFT).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), (ItemLike)AllItems.PROPELLER)));
        this.createForSetElement("gearbox", CasingSet::doesGenerateGearbox, CasingSet::getGearbox, (builder, set) -> builder.viaShaped(sh -> sh.pattern(" B ").pattern("BCB").pattern(" B ").define(Character.valueOf('B'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('C'), (ItemLike)set.getCasing())));
        this.createForSetElement("gearbox", CasingSet::doesGenerateGearbox, CasingSet::getGearbox, (builder, set) -> builder.suffix("_from_conversion").viaShapeless(sh -> sh.requires((ItemLike)set.getVerticalGearboxItem())));
        this.createForSetElement("gearbox", CasingSet::doesGenerateGearbox, CasingSet::getVerticalGearboxItem, (builder, set) -> builder.suffix("_vertical").viaShaped(sh -> sh.pattern("B B").pattern(" C ").pattern("B B").define(Character.valueOf('B'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('C'), (ItemLike)set.getCasing())));
        this.createForSetElement("gearbox", CasingSet::doesGenerateGearbox, CasingSet::getVerticalGearboxItem, (builder, set) -> builder.suffix("_vertical_from_conversion").viaShapeless(sh -> sh.requires((ItemLike)set.getGearbox())));
        this.createForSetElement("gearshift", CasingSet::doesGenerateGearshift, CasingSet::getGearshift, (builder, set) -> builder.viaShapeless(sh -> sh.requires((ItemLike)set.getCasing()).requires((ItemLike)AllBlocks.COGWHEEL).requires(Tags.Items.DUSTS_REDSTONE)));
        this.createForSetElement("mixer", CasingSet::doesGenerateMixer, CasingSet::getMixer, (builder, set) -> builder.viaShaped(sh -> sh.pattern("B").pattern("C").pattern("I").define(Character.valueOf('B'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), (ItemLike)AllItems.WHISK)));
        this.createForSetElement("portable_storage_interface", CasingSet::doesGenerateStorageInterface, CasingSet::getStorageInterface, (builder, set) -> builder.viaShapeless(sh -> sh.requires((ItemLike)set.getCasing()).requires((ItemLike)AllBlocks.CHUTE)));
        this.createForSetElement("press", CasingSet::doesGeneratePress, CasingSet::getPress, (builder, set) -> builder.viaShaped(sh -> sh.pattern("B").pattern("C").pattern("I").define(Character.valueOf('B'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), Tags.Items.STORAGE_BLOCKS_IRON)));
        this.createForSetElement("roller", CasingSet::doesGenerateRoller, CasingSet::getRoller, (builder, set) -> builder.viaShaped(sh -> sh.pattern("B").pattern("C").pattern("I").define(Character.valueOf('B'), (ItemLike)AllItems.ELECTRON_TUBE).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), (ItemLike)AllBlocks.CRUSHING_WHEEL)));
        this.createForSetElement("saw", CasingSet::doesGenerateSaw, CasingSet::getSaw, (builder, set) -> builder.viaShaped(sh -> sh.pattern(" B ").pattern("BIB").pattern(" C ").define(Character.valueOf('B'), CommonMetal.IRON.plates).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON)));
        this.createForSetElement("plough", CasingSet::doesGeneratePlough, CasingSet::getPlough, (builder, set) -> builder.viaShaped(sh -> sh.pattern("BBB").pattern("III").pattern(" C ").define(Character.valueOf('B'), CommonMetal.IRON.plates).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), (ItemLike)AllItems.ANDESITE_ALLOY)));
        this.createForSetElement("harvester", CasingSet::doesGenerateHarvester, CasingSet::getHarvester, (builder, set) -> builder.viaShaped(sh -> sh.pattern("IBI").pattern("IBI").pattern(" C ").define(Character.valueOf('B'), CommonMetal.IRON.plates).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), (ItemLike)AllItems.ANDESITE_ALLOY)));
        this.createForSetElement("drill", CasingSet::doesGenerateDrill, CasingSet::getDrill, (builder, set) -> builder.viaShaped(sh -> sh.pattern(" I ").pattern("IBI").pattern(" C ").define(Character.valueOf('B'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), (ItemLike)set.getCasing()).define(Character.valueOf('I'), (ItemLike)AllItems.ANDESITE_ALLOY)));
    }

    private void createForSetElement(String folderName, Predicate<CasingSet> exists, Function<CasingSet, ? extends ItemLike> block, BiFunction<GeneratedRecipeBuilder, CasingSet, BaseRecipeProvider.GeneratedRecipe> recipeGenerator) {
        this.enterFolder(folderName);
        CasingSets.getSets().stream().filter(exists).forEach(set -> recipeGenerator.apply(this.create(set.getName(), (Supplier<ItemLike>)((Supplier)() -> (ItemLike)block.apply((CasingSet)set))).unlockedBy((Supplier<? extends ItemLike>)((Supplier)set::getCasing)), (CasingSet)set));
        this.leftLastFolder();
    }

    class GeneratedRecipeBuilder {
        private String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        List<ICondition> recipeConditions;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.amount = 1;
            this.suffix = "";
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return EncasedRecipeGens.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", EncasedRecipeGens.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return EncasedRecipeGens.this.register(recipeOutput -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", EncasedRecipeGens.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                RecipeOutput conditionalOutput = recipeOutput.withConditions(this.recipeConditions.toArray(new ICondition[0]));
                b.save(recipeOutput, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            return EncasedRecipeGens.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)RecipeCategory.COMBAT, (Item)((ItemLike)this.result.get()).asItem());
                b.unlocks("has_item", EncasedRecipeGens.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)base.get()}).build()}));
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return CreateCasing.asResource(this.path + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            if (this.path.isEmpty()) {
                return CreateCasing.asResource(String.valueOf(RegisteredObjectsHelper.getKeyOrThrow((ItemLike)((ItemLike)this.result.get()))) + this.suffix);
            }
            return CreateCasing.asResource(this.path + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem());
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((TagKey)((TagKey)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                this.create(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, builder, CampfireCookingRecipe::new, 3.0f);
                return this.create(RecipeSerializer.SMOKING_RECIPE, builder, SmokingRecipe::new, 0.5f);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                return this.create(RecipeSerializer.BLASTING_RECIPE, builder, BlastingRecipe::new, 0.5f);
            }

            private <T extends AbstractCookingRecipe> BaseRecipeProvider.GeneratedRecipe create(RecipeSerializer<T> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, AbstractCookingRecipe.Factory<T> factory, float cookingTimeModifier) {
                return EncasedRecipeGens.this.register(recipeOutput -> {
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.generic((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.unlockedBy("has_item", EncasedRecipeGens.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    RecipeOutput conditionalOutput = recipeOutput.withConditions(GeneratedRecipeBuilder.this.recipeConditions.toArray(new ICondition[0]));
                    b.save(conditionalOutput, GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer).getPath()));
                });
            }
        }
    }
}

