/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import com.google.common.collect.ImmutableMap;
import me.pepperbell.continuity.client.mixinterface.ModelLoaderExtension;
import me.pepperbell.continuity.client.model.CtmBakedModel;
import me.pepperbell.continuity.client.model.EmissiveBakedModel;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class ModelWrappingHandler {
    private final boolean wrapCtm;
    private final boolean wrapEmissive;
    private final ImmutableMap<ModelResourceLocation, BlockState> blockStateModelIds;

    private ModelWrappingHandler(boolean wrapCtm, boolean wrapEmissive) {
        this.wrapCtm = wrapCtm;
        this.wrapEmissive = wrapEmissive;
        this.blockStateModelIds = ModelWrappingHandler.createBlockStateModelIdMap();
    }

    @Nullable
    public static ModelWrappingHandler create(boolean wrapCtm, boolean wrapEmissive) {
        if (!wrapCtm && !wrapEmissive) {
            return null;
        }
        return new ModelWrappingHandler(wrapCtm, wrapEmissive);
    }

    private static ImmutableMap<ModelResourceLocation, BlockState> createBlockStateModelIdMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Block block : BuiltInRegistries.BLOCK) {
            ResourceLocation blockId = block.builtInRegistryHolder().key().location();
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                ModelResourceLocation modelId = BlockModelShaper.stateToModelLocation((ResourceLocation)blockId, (BlockState)state);
                builder.put((Object)modelId, (Object)state);
            }
        }
        return builder.build();
    }

    public BakedModel wrap(@Nullable BakedModel model, @UnknownNullability ResourceLocation resourceId, @UnknownNullability ModelResourceLocation topLevelId) {
        if (!(model == null || model.isCustomRenderer() || resourceId != null && resourceId.equals((Object)ModelBakery.MISSING_MODEL_LOCATION))) {
            BlockState state;
            if (this.wrapCtm && topLevelId != null && (state = (BlockState)this.blockStateModelIds.get((Object)topLevelId)) != null) {
                model = new CtmBakedModel((BakedModel)model, state);
            }
            if (this.wrapEmissive) {
                model = new EmissiveBakedModel((BakedModel)model);
            }
        }
        return model;
    }

    @ApiStatus.Internal
    public static void init() {
        ModelLoadingPlugin.register(pluginCtx -> pluginCtx.modifyModelAfterBake().register(ModelModifier.WRAP_LAST_PHASE, (model, ctx) -> {
            ModelBakery modelLoader = ctx.loader();
            ModelWrappingHandler wrappingHandler = ((ModelLoaderExtension)modelLoader).continuity$getModelWrappingHandler();
            if (wrappingHandler != null) {
                return wrappingHandler.wrap(model, ctx.resourceId(), ctx.topLevelId());
            }
            return model;
        }));
    }
}

