/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import java.util.Locale;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class BasicConnectingCtmProperties
extends BaseCtmProperties {
    protected ConnectionPredicate connectionPredicate;

    public BasicConnectingCtmProperties(Properties properties, ResourceLocation resourceId, PackResources pack, int packPriority, ResourceManager resourceManager, String method) {
        super(properties, resourceId, pack, packPriority, resourceManager, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseConnect();
        this.detectConnect();
        this.validateConnect();
    }

    protected void parseConnect() {
        String connectStr = this.properties.getProperty("connect");
        if (connectStr == null) {
            return;
        }
        try {
            this.connectionPredicate = ConnectionType.valueOf(connectStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void detectConnect() {
        if (this.connectionPredicate == null) {
            if (this.matchBlocksPredicate != null) {
                this.connectionPredicate = ConnectionType.BLOCK;
            } else if (this.matchTilesSet != null) {
                this.connectionPredicate = ConnectionType.TILE;
            }
        }
    }

    protected void validateConnect() {
        if (this.connectionPredicate == null) {
            ContinuityClient.LOGGER.error("No valid connection type provided in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
            this.valid = false;
        }
    }

    public ConnectionPredicate getConnectionPredicate() {
        return this.connectionPredicate;
    }

    public static enum ConnectionType implements ConnectionPredicate
    {
        BLOCK{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return appearanceState.getBlock() == otherAppearanceState.getBlock();
            }
        }
        ,
        TILE{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                if (appearanceState == otherAppearanceState) {
                    return true;
                }
                return quadSprite == SpriteCalculator.getSprite(otherAppearanceState, face);
            }
        }
        ,
        STATE{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return appearanceState == otherAppearanceState;
            }
        };

    }
}

