/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.fluid.builder;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.averageanime.neoforge.block.ModBlocks;
import dev.averageanime.neoforge.fluid.ModFluids;
import dev.averageanime.neoforge.item.ModItems;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.joml.Vector3f;

public class CustomFluidType {
    public final DeferredHolder<FluidType, FluidType> FLUID_TYPE;
    public final DeferredHolder<Fluid, FlowingFluid> SOURCE;
    public final DeferredHolder<Fluid, FlowingFluid> FLOWING;
    public final DeferredBlock<LiquidBlock> BLOCK;
    public final DeferredItem<Item> BUCKET;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final int slopeFindDistance;
    private final int levelDecreasePerBlock;

    public CustomFluidType(String name, final Vector3f fogColor, FluidType.Properties fluidTypeProperties, int slopeFindDistance, int levelDecreasePerBlock) {
        this.stillTexture = ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("fluid/" + name + "_still"));
        this.flowingTexture = ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("fluid/" + name + "_flow"));
        this.slopeFindDistance = slopeFindDistance;
        this.levelDecreasePerBlock = levelDecreasePerBlock;
        this.FLUID_TYPE = ModFluids.FLUID_TYPES.register(name, () -> new FluidType(fluidTypeProperties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return CustomFluidType.this.stillTexture;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return CustomFluidType.this.flowingTexture;
                    }

                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        return fogColor;
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        RenderSystem.setShaderFogColor((float)fogColor.x(), (float)fogColor.y(), (float)fogColor.z());
                        RenderSystem.setShaderFogStart((float)0.5f);
                        RenderSystem.setShaderFogEnd((float)1.5f);
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                    }
                });
            }
        });
        this.SOURCE = ModFluids.FLUIDS.register(name, () -> new BaseFlowingFluid.Source(this.createFluidPropertiesInternal()));
        this.FLOWING = ModFluids.FLUIDS.register("flowing_" + name, () -> new BaseFlowingFluid.Flowing(this.createFluidPropertiesInternal()));
        this.BLOCK = ModBlocks.BLOCKS.register(name + "_block", () -> new LiquidBlock((FlowingFluid)this.SOURCE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
        this.BUCKET = ModItems.ITEMS.register(name + "_bucket", () -> new BucketItem((Fluid)this.SOURCE.get(), new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
    }

    private BaseFlowingFluid.Properties createFluidPropertiesInternal() {
        return new BaseFlowingFluid.Properties(this.FLUID_TYPE, this.SOURCE, this.FLOWING).slopeFindDistance(this.slopeFindDistance).levelDecreasePerBlock(this.levelDecreasePerBlock).block(this.BLOCK).bucket(this.BUCKET).tickRate(25);
    }
}

