/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.motor;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.motor.MotorBlockEntity;
import org.antarcticgardens.cna.content.motor.variants.IMotorVariant;
import org.antarcticgardens.cna.util.StringFormatUtil;

public class MotorBlock
extends DirectionalKineticBlock
implements IRotate,
IBE<MotorBlockEntity> {
    protected static final VoxelShape Y_AXIS_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private final IMotorVariant variant;
    BlockEntityEntry<MotorBlockEntity> entry;

    public MotorBlock(BlockBehaviour.Properties properties, BlockEntityEntry<MotorBlockEntity> entry, IMotorVariant variant) {
        super(properties);
        this.variant = variant;
        this.entry = entry;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)CreateLang.translate((String)"tooltip.create_new_age.generates", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltipComponents.add((Component)CreateLang.text((String)" ").add(CreateLang.number((double)((double)this.variant.getStress() * (Double)CNAConfig.getCommon().motorSUMultiplier.get())).text(" ").translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA)).component());
        tooltipComponents.add((Component)CreateLang.translate((String)"tooltip.create_new_age.stores", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltipComponents.add((Component)CreateLang.text((String)" ").translate("tooltip.create_new_age.energy", new Object[]{StringFormatUtil.formatLong(this.variant.getMaxCapacity())}).style(ChatFormatting.AQUA).component());
        tooltipComponents.add((Component)CreateLang.translate((String)"tooltip.create_new_age.max_speed", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltipComponents.add((Component)CreateLang.text((String)" ").translate("tooltip.create_new_age.rpm", new Object[]{Float.valueOf(this.variant.getSpeed())}).style(ChatFormatting.AQUA).component());
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.NONE;
    }

    public void destroy(LevelAccessor arg, BlockPos arg2, BlockState arg3) {
        BlockEntity entity;
        if (arg3.hasBlockEntity() && (entity = arg.getBlockEntity(arg2)) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.speedBehavior.value = 0;
            en.updateGeneratedRotation();
        }
        super.destroy(arg, arg2, arg3);
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction f = super.getPreferredFacing(context);
        return f == null ? null : f.getOpposite();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.getValue((Property)FACING);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (world instanceof ServerLevel) {
            if (player != null && !player.isCreative()) {
                Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)context.getItemInHand()).forEach(itemStack -> player.getInventory().placeItemBackInInventory(itemStack));
            }
            state.spawnAfterBreak((ServerLevel)world, pos, ItemStack.EMPTY, true);
            world.destroyBlock(pos, false);
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity entity;
        if (state.hasBlockEntity() && (entity = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.needsPower = !en.needsPower;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void neighborChanged(BlockState arg, Level arg2, BlockPos arg3, Block arg4, BlockPos arg5, boolean bl) {
        BlockEntity entity;
        if (arg.hasBlockEntity() && !arg2.isClientSide && (entity = arg2.getBlockEntity(arg3)) instanceof MotorBlockEntity) {
            MotorBlockEntity en = (MotorBlockEntity)entity;
            en.powered = arg2.hasNeighborSignal(arg3);
        }
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.getValue((Property)FACING)).getAxis();
    }

    public VoxelShape getShape(BlockState arg, BlockGetter arg2, BlockPos arg3, CollisionContext arg4) {
        return switch (((Direction)arg.getValue((Property)FACING)).getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
            case Direction.Axis.Y -> Y_AXIS_AABB;
        };
    }

    public Class<MotorBlockEntity> getBlockEntityClass() {
        return MotorBlockEntity.class;
    }

    public BlockEntityType<? extends MotorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)this.entry.get();
    }
}

