/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.heat.stirling;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.content.heat.stirling.StirlingEngineBlockEntity;

public class StirlingEngineRenderer
extends KineticBlockEntityRenderer<StirlingEngineBlockEntity> {
    public StirlingEngineRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(StirlingEngineBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        if (!VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState blockState = (BlockState)AllBlocks.FLYWHEEL.getDefaultState().setValue((Property)BlockStateProperties.AXIS, (Comparable)((Direction.Axis)be.getBlockState().getValue((Property)BlockStateProperties.AXIS)));
        float speed = be.visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = be.angle + speed * partialTicks;
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        this.renderFlywheel(be, ms, light, blockState, angle, vb);
    }

    private void renderFlywheel(StirlingEngineBlockEntity be, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        SuperByteBuffer wheel = (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.block((BlockState)blockState).center()).scale(0.2f, 0.2f, 0.2f)).uncenter();
        StirlingEngineRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticBlockEntity)be, (Direction.Axis)StirlingEngineRenderer.getRotationAxisOf((KineticBlockEntity)be), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.renderInto(ms, vb);
    }

    protected BlockState getRenderedBlockState(StirlingEngineBlockEntity be) {
        return (BlockState)AllBlocks.SHAFT.getDefaultState().setValue((Property)BlockStateProperties.AXIS, (Comparable)((Direction.Axis)be.getBlockState().getValue((Property)BlockStateProperties.AXIS)));
    }
}

