/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.energising;

import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.antarcticgardens.cna.CNARecipeTypes;
import org.antarcticgardens.cna.content.energising.EnergiserBlock;
import org.antarcticgardens.cna.content.energising.EnergiserBlockEntity;
import org.antarcticgardens.cna.content.energising.recipe.EnergisingRecipe;
import org.antarcticgardens.esl.energy.EnergyHelper;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.transaction.Transaction;
import org.antarcticgardens.esl.transaction.TransactionContext;
import org.antarcticgardens.esl.transaction.TransactionStack;
import org.antarcticgardens.esl.util.ItemHolder;
import org.antarcticgardens.esl.util.ItemStackHolder;
import org.joml.Math;

public class EnergiserBehaviour
extends BeltProcessingBehaviour {
    protected int tier;
    protected EnergiserBlockEntity be;
    public boolean capacitorMode = false;
    public EnergisingRecipe currentRecipe;
    public long charged;
    public long needed;
    private boolean shouldCreateParticles = false;
    public long sinceUpdate = 0L;

    public EnergiserBehaviour(EnergiserBlockEntity be) {
        super((SmartBlockEntity)be);
        this.whenItemEnters(this::itemEnter);
        this.whileItemHeld(this::itemHeld);
        this.be = be;
    }

    public EnergisingRecipe getRecipe(ItemStack stack) {
        if (this.be.getLevel() == null) {
            return null;
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.getWorld(), (ItemStack)stack, CNARecipeTypes.ENERGISING.getType(), EnergisingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return (EnergisingRecipe)((RecipeHolder)assemblyRecipe.get()).value();
        }
        List recipes = this.be.getLevel().getRecipeManager().getAllRecipesFor(CNARecipeTypes.ENERGISING.getType());
        for (RecipeHolder recipe : recipes) {
            if (!((EnergisingRecipe)recipe.value()).test(stack)) continue;
            return (EnergisingRecipe)recipe.value();
        }
        return null;
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        this.charged = nbt.getLong("charged");
        this.needed = nbt.getLong("needed");
        this.shouldCreateParticles = nbt.getBoolean("shouldCreateParticles");
        this.capacitorMode = nbt.getBoolean("capacitorModer");
        super.read(nbt, registries, clientPacket);
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        nbt.putLong("charged", this.charged);
        nbt.putLong("needed", this.needed);
        nbt.putBoolean("shouldCreateParticles", this.shouldCreateParticles);
        nbt.putBoolean("capacitorMode", this.capacitorMode);
        if (clientPacket) {
            this.shouldCreateParticles = false;
        }
        super.write(nbt, registries, clientPacket);
    }

    public void tick() {
        super.tick();
        if (this.be.getLevel() == null) {
            return;
        }
        if (!this.be.getLevel().isClientSide() && this.needed > 0L) {
            --this.sinceUpdate;
            if (this.sinceUpdate <= 0L) {
                this.needed = 0L;
                this.be.getEnergyStorage().internalInsert(this.charged, false);
                this.charged = 0L;
                this.currentRecipe = null;
                this.capacitorMode = false;
                this.blockEntity.sendData();
            }
        }
        if (!this.capacitorMode) {
            this.be.lastCharged = -1L;
            if (this.needed > 0L) {
                this.be.lastCharged = this.be.getEnergyStorage().internalExtract((long)Math.min((float)this.eSpeed(), (float)(this.needed - this.charged)), false);
                this.charged += this.be.lastCharged;
            }
        }
        if (this.be.getLevel().isClientSide()) {
            this.be.size -= 0.15f;
            this.be.size = Math.clamp((float)0.0f, (float)1.0f, (float)this.be.size);
            if (this.needed > 0L && this.charged > 0L) {
                this.be.size = (float)Math.lerp((double)this.be.size, (double)((float)this.charged / (float)this.needed), (double)0.6);
            } else if (this.shouldCreateParticles) {
                this.shouldCreateParticles = false;
                RandomSource rand = this.be.getLevel().getRandom();
                for (int i = 0; i < 6; ++i) {
                    this.be.getLevel().addParticle((ParticleOptions)ParticleTypes.GLOW, false, (double)this.be.getBlockPos().getX() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.4, (double)this.be.getBlockPos().getY() - 1.4 + ((double)rand.nextFloat() - 0.5) * 0.4, (double)this.be.getBlockPos().getZ() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.4, 0.0, 0.5, 0.0);
                }
                this.be.getLevel().playLocalSound((double)this.be.getBlockPos().getX() + 0.5, (double)this.be.getBlockPos().getY() - 1.4, (double)this.be.getBlockPos().getZ() + 0.5, SoundEvents.ENDER_EYE_DEATH, SoundSource.BLOCKS, 0.3f, 2.0f, true);
            }
        }
    }

    private BeltProcessingBehaviour.ProcessingResult itemHeld(TransportedItemStack transportedItemStack, TransportedItemStackHandlerBehaviour handler) {
        if (this.currentRecipe == null) {
            this.currentRecipe = this.getRecipe(transportedItemStack.stack);
        }
        if (this.be.getSpeed() == 0.0f || this.currentRecipe == null && !this.capacitorMode || this.be.getLevel() == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.capacitorMode) {
            ItemStackHolder holder = new ItemStackHolder(transportedItemStack.stack);
            EnergyStorage itemStorage = EnergyStorage.findForItem((ItemHolder)holder);
            if (itemStorage != null) {
                try (Transaction t = TransactionStack.get().openOuter();){
                    this.be.lastCharged = EnergyHelper.moveEnergy((EnergyStorage)this.be.getEnergyStorage(), (EnergyStorage)itemStorage, (long)this.eSpeed(), (TransactionContext)t);
                    this.charged = itemStorage.getStoredEnergy();
                    this.needed = itemStorage.getCapacity();
                    this.sinceUpdate = 10L;
                    transportedItemStack.stack = holder.toItemStack();
                    this.blockEntity.sendData();
                    if (this.charged >= this.needed) {
                        this.capacitorMode = false;
                        this.charged = 0L;
                        this.needed = 0L;
                        this.shouldCreateParticles = true;
                        BeltProcessingBehaviour.ProcessingResult processingResult = BeltProcessingBehaviour.ProcessingResult.PASS;
                        return processingResult;
                    }
                    t.commit();
                }
                return BeltProcessingBehaviour.ProcessingResult.HOLD;
            }
            this.capacitorMode = false;
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        int count = transportedItemStack.stack.getCount();
        this.needed = (long)count * (long)this.currentRecipe.getEnergyNeeded();
        this.sinceUpdate = 10L;
        if (this.charged >= this.needed) {
            List out = this.currentRecipe.rollResults(handler.getWorld().getRandom()).stream().map(stack -> {
                TransportedItemStack copy = transportedItemStack.copy();
                boolean centered = BeltHelper.isItemUpright((ItemStack)stack);
                stack.setCount(stack.getCount() * count);
                copy.stack = stack;
                copy.angle = centered ? 180 : this.be.getLevel().getRandom().nextInt(360);
                return copy;
            }).collect(Collectors.toList());
            if (this.charged > this.needed) {
                this.be.getEnergyStorage().internalInsert(this.charged - this.needed, false);
            }
            this.charged = 0L;
            this.needed = 0L;
            if (out.isEmpty()) {
                handler.handleProcessingOnItem(transportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            } else {
                handler.handleProcessingOnItem(transportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(out));
            }
            this.shouldCreateParticles = true;
            this.blockEntity.sendData();
            this.currentRecipe = null;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private long eSpeed() {
        return (long)EnergiserBlock.getStrength(this.be.tier) * (long)Math.abs((double)((double)this.be.getSpeed() * 0.1));
    }

    private BeltProcessingBehaviour.ProcessingResult itemEnter(TransportedItemStack transportedItemStack, TransportedItemStackHandlerBehaviour transportedItemStackHandlerBehaviour) {
        if (this.be.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        EnergyStorage itemStorage = EnergyStorage.findForItem((ItemHolder)new ItemStackHolder(transportedItemStack.stack));
        if (itemStorage != null && itemStorage.getStoredEnergy() < itemStorage.getCapacity()) {
            this.capacitorMode = true;
            this.charged = itemStorage.getStoredEnergy();
            this.needed = itemStorage.getCapacity();
            this.sinceUpdate = 10L;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        this.capacitorMode = false;
        this.currentRecipe = this.getRecipe(transportedItemStack.stack);
        this.sinceUpdate = 10L;
        if (this.currentRecipe == null || this.currentRecipe.getIngredients().size() > 1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }
}

