/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.neoforge.index;

import java.util.LinkedList;
import java.util.List;
import net.createcobblestone.neoforge.CreateCobblestoneNeoForge;
import net.createcobblestone.neoforge.data.GeneratorType;
import net.createcobblestone.neoforge.index.Blocks;
import net.createcobblestone.neoforge.index.Config;
import net.createcobblestone.neoforge.index.CreativeTabs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public final class RegistrateDisplayItemsGenerator
implements CreativeModeTab.DisplayItemsGenerator {
    private final CreativeTabs.Tabs tab;

    public RegistrateDisplayItemsGenerator(CreativeTabs.Tabs tab) {
        this.tab = tab;
    }

    public void accept(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CreativeModeTab.ItemDisplayParameters pParameters, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CreativeModeTab.Output output) {
        ResourceKey<CreativeModeTab> tab = this.tab.getKey();
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        ItemStack stack = Blocks.MECHANICAL_GENERATOR_BLOCK.asStack();
        GeneratorType.NONE.writeToItemStack(stack);
        stacks.add(stack);
        for (GeneratorType type : GeneratorType.getTypes()) {
            if (type == GeneratorType.NONE) continue;
            stack = Blocks.MECHANICAL_GENERATOR_BLOCK.asStack();
            type.writeToItemStack(stack);
            stacks.add(stack);
            if (!((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) continue;
            CreateCobblestoneNeoForge.LOGGER.info("Added {} generator to creative menu", (Object)type.getId());
        }
        RegistrateDisplayItemsGenerator.outputAll(output, stacks);
    }

    private static void outputAll(CreativeModeTab.Output output, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.getCount() != 1) {
                CreateCobblestoneNeoForge.LOGGER.error("Invalid stack size {} for stack {}.", (Object)stack.getCount(), (Object)stack);
                continue;
            }
            output.accept(stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static DeferredHolder<CreativeModeTab, CreativeModeTab> getTabObject(ResourceKey<CreativeModeTab> tab) {
        return CreativeTabs.MAIN_TAB;
    }

    public record TabInfo(ResourceKey<CreativeModeTab> key, CreativeModeTab tab) {
    }
}

