/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.neoforge.data;

import java.util.ArrayList;
import java.util.List;
import net.createcobblestone.neoforge.index.Network;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public record GeneratorTypesPayload(List<GeneratorTypePayload> list) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GeneratorTypesPayload> TYPE = new CustomPacketPayload.Type(Network.GENERATOR_TYPES_PACKET);
    public static final StreamCodec<FriendlyByteBuf, GeneratorTypesPayload> STREAM_CODEC = StreamCodec.of(GeneratorTypesPayload::encode, GeneratorTypesPayload::decode);

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static void encode(FriendlyByteBuf buf, GeneratorTypesPayload payload) {
        List<GeneratorTypePayload> l = payload.list;
        buf.writeVarInt(l.size());
        for (GeneratorTypePayload gt : l) {
            GeneratorTypePayload.STREAM_CODEC.encode((Object)buf, (Object)gt);
        }
    }

    private static GeneratorTypesPayload decode(FriendlyByteBuf buf) {
        int n = buf.readVarInt();
        ArrayList<GeneratorTypePayload> out = new ArrayList<GeneratorTypePayload>(n);
        for (int i = 0; i < n; ++i) {
            out.add((GeneratorTypePayload)GeneratorTypePayload.STREAM_CODEC.decode((Object)buf));
        }
        return new GeneratorTypesPayload(out);
    }

    public record GeneratorTypePayload(String id, String block, int stress, float ratio, int storage) {
        public static final StreamCodec<FriendlyByteBuf, GeneratorTypePayload> STREAM_CODEC = StreamCodec.of((buf, v) -> {
            buf.writeUtf(v.id);
            buf.writeUtf(v.block);
            buf.writeVarInt(v.stress);
            buf.writeFloat(v.ratio);
            buf.writeVarInt(v.storage);
        }, buf -> new GeneratorTypePayload(buf.readUtf(), buf.readUtf(), buf.readVarInt(), buf.readFloat(), buf.readVarInt()));
    }
}

