/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.utils;

import ca.fxco.moreculling.MoreCulling;
import ca.fxco.moreculling.api.block.LeavesCulling;
import ca.fxco.moreculling.api.blockstate.MoreStateCulling;
import ca.fxco.moreculling.api.blockstate.StateCullingShapeCache;
import ca.fxco.moreculling.utils.CompatUtils;
import ca.fxco.moreculling.utils.DirectionUtils;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Optional;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CullingUtils {
    public static final RandomSource RANDOM = RandomSource.createNewThreadLocalInstance();

    public static boolean shouldDrawSideCulling(BlockState thisState, BlockGetter world, BlockPos thisPos, Direction side, BlockPos sidePos) {
        Optional<Boolean> shouldDrawFace;
        BlockState sideState = world.getBlockState(sidePos);
        if (thisState.skipRendering(sideState, side)) {
            return false;
        }
        if (((MoreStateCulling)thisState).moreculling$usesCustomShouldDrawFace() && (shouldDrawFace = ((MoreStateCulling)thisState).moreculling$customShouldDrawFace(world, sideState, thisPos, sidePos, side)).isPresent()) {
            return shouldDrawFace.get();
        }
        if (((MoreStateCulling)sideState).moreculling$canCull() && (sideState.canOcclude() || !sideState.getRenderShape().equals((Object)RenderShape.INVISIBLE) && ((MoreStateCulling)thisState).moreculling$shouldAttemptToCull(side, world, thisPos) && ((MoreStateCulling)sideState).moreculling$shouldAttemptToCull(side.getOpposite(), world, sidePos))) {
            return CullingUtils.shouldDrawFace(world, thisState, sideState, thisPos, sidePos, side);
        }
        return true;
    }

    private static boolean shouldDrawFace(BlockGetter world, BlockState thisState, BlockState sideState, BlockPos thisPos, BlockPos sidePos, Direction side) {
        if (((MoreStateCulling)sideState).moreculling$cantCullAgainst(side)) {
            return true;
        }
        Block.BlockStatePairKey statePairKey = new Block.BlockStatePairKey(thisState, sideState, side);
        Object2ByteLinkedOpenHashMap object2ByteLinkedOpenHashMap = (Object2ByteLinkedOpenHashMap)Block.OCCLUSION_CACHE.get();
        byte b = object2ByteLinkedOpenHashMap.getAndMoveToFirst((Object)statePairKey);
        if (b != 127) {
            return b != 0;
        }
        Direction opposite = side.getOpposite();
        VoxelShape sideShape = ((StateCullingShapeCache)sideState).moreculling$getFaceCullingShape(opposite);
        if (sideShape == Shapes.block()) {
            return false;
        }
        VoxelShape thisShape = ((StateCullingShapeCache)thisState).moreculling$getFaceCullingShape(side);
        if (sideShape == Shapes.empty() || thisShape == Shapes.empty()) {
            return true;
        }
        boolean bl = Shapes.joinIsNotEmpty((VoxelShape)thisShape, (VoxelShape)sideShape, (BooleanOp)BooleanOp.ONLY_FIRST);
        if (object2ByteLinkedOpenHashMap.size() == 2048) {
            object2ByteLinkedOpenHashMap.removeLastByte();
        }
        object2ByteLinkedOpenHashMap.putAndMoveToFirst((Object)statePairKey, (byte)(bl ? 1 : 0));
        return bl;
    }

    public static boolean areLeavesOpaque() {
        GraphicsStatus mode = (GraphicsStatus)Minecraft.getInstance().options.graphicsMode().get();
        return CompatUtils.IS_SODIUM_LOADED ? !SodiumClientMod.options().quality.leavesQuality.isFancy(mode) : mode.getId() < GraphicsStatus.FANCY.getId();
    }

    public static Optional<Boolean> shouldDrawFaceCheck(BlockGetter view, BlockState sideState, BlockPos thisPos, BlockPos sidePos, Direction side) {
        if (sideState.getBlock() instanceof LeavesCulling || sideState.canOcclude() && ((StateCullingShapeCache)sideState).moreculling$getFaceCullingShape(side.getOpposite()) == Shapes.block()) {
            boolean isSurrounded = true;
            for (Direction dir : DirectionUtils.DIRECTIONS) {
                if (dir == side) continue;
                BlockPos pos = thisPos.relative(dir);
                BlockState state = view.getBlockState(pos);
                isSurrounded &= state.getBlock() instanceof LeavesCulling || state.canOcclude() && ((StateCullingShapeCache)state).moreculling$getFaceCullingShape(dir.getOpposite()) == Shapes.block();
            }
            return isSurrounded ? Optional.of(false) : Optional.empty();
        }
        return Optional.of(true);
    }

    public static Optional<Boolean> shouldDrawFaceGap(BlockGetter view, BlockState sideState, BlockPos sidePos, Direction side) {
        Direction oppositeSide = side.getOpposite();
        if (sideState.getBlock() instanceof LeavesCulling || sideState.canOcclude() && ((StateCullingShapeCache)sideState).moreculling$getFaceCullingShape(oppositeSide) == Shapes.block()) {
            for (int i = 1; i < 5 - MoreCulling.CONFIG.leavesCullingAmount; ++i) {
                BlockPos pos = sidePos.relative(side, i);
                BlockState state = view.getBlockState(pos);
                if (state != null && (state.getBlock() instanceof LeavesCulling || state.canOcclude() && ((StateCullingShapeCache)state).moreculling$getFaceCullingShape(oppositeSide) == Shapes.block())) continue;
                return Optional.of(false);
            }
        }
        return Optional.of(true);
    }

    public static Optional<Boolean> shouldDrawFaceDepth(BlockGetter view, BlockState sideState, BlockPos sidePos, Direction side) {
        if (sideState.getBlock() instanceof LeavesCulling || sideState.canOcclude() && ((StateCullingShapeCache)sideState).moreculling$getFaceCullingShape(side.getOpposite()) == Shapes.block()) {
            for (int i = 1; i < MoreCulling.CONFIG.leavesCullingAmount + 1; ++i) {
                BlockState state = view.getBlockState(sidePos.relative(side, i));
                if (state != null && !state.isAir()) continue;
                return Optional.of(true);
            }
            return Optional.of(false);
        }
        return Optional.of(true);
    }

    public static Optional<Boolean> shouldDrawFaceRandom(BlockGetter view, BlockState sideState, BlockPos sidePos, Direction side) {
        if ((sideState.getBlock() instanceof LeavesCulling || sideState.canOcclude() && ((StateCullingShapeCache)sideState).moreculling$getFaceCullingShape(side.getOpposite()) == Shapes.block()) && RANDOM.nextIntBetweenInclusive(1, MoreCulling.CONFIG.leavesCullingAmount + 1) == 1) {
            return Optional.of(false);
        }
        return Optional.of(true);
    }

    public static boolean shouldCullBack(ItemFrame frame) {
        Direction dir = frame.getDirection();
        BlockPos posBehind = frame.getPos().relative(dir.getOpposite());
        BlockState blockState = frame.level().getBlockState(posBehind);
        return blockState.canOcclude() && ((StateCullingShapeCache)blockState).moreculling$getFaceCullingShape(dir) == Shapes.block();
    }

    public static boolean shouldShowMapFace(Direction facingDir, Vec3 framePos, Vec3 cameraPos) {
        if (MoreCulling.CONFIG.itemFrameMapCulling) {
            return switch (facingDir) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> {
                    if (cameraPos.y <= framePos.y) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.UP -> {
                    if (cameraPos.y >= framePos.y) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.NORTH -> {
                    if (cameraPos.z <= framePos.z) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.SOUTH -> {
                    if (cameraPos.z >= framePos.z) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.WEST -> {
                    if (cameraPos.x <= framePos.x) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.EAST -> cameraPos.x >= framePos.x;
            };
        }
        return true;
    }

    public static boolean shouldHideWallSignText(Direction facingDir, Vec3 framePos, Vec3 cameraPos) {
        return switch (facingDir) {
            case Direction.NORTH -> {
                if (cameraPos.z > framePos.z) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (cameraPos.z < framePos.z) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (cameraPos.x > framePos.x) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (cameraPos.x < framePos.x) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean shouldCullPaintingBack(BlockPos paintingPos, Direction oppositeDir) {
        BlockPos posBehind = paintingPos.relative(oppositeDir, 1);
        BlockState blockState = Minecraft.getInstance().level.getBlockState(posBehind);
        return blockState.canOcclude() && ((StateCullingShapeCache)blockState).moreculling$getFaceCullingShape(oppositeDir) == Shapes.block();
    }
}

