/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.tom.createores.block.IOBlock;
import com.tom.createores.block.MultiblockPart;
import com.tom.createores.block.entity.MultiblockCapHandler;
import com.tom.createores.util.IOBlockType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class IOBlockEntity
extends BlockEntity
implements IHaveGoggleInformation {
    private IOBlockType type;

    public IOBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
        this.type = (IOBlockType)((Object)pBlockState.getValue(IOBlock.TYPE));
    }

    public <T> T getCapability(BlockCapability<T, Direction> cap, Direction side) {
        if (this.type.getCap() == cap) {
            BlockEntity te;
            MultiblockPart d;
            BlockState state = this.level.getBlockState(this.worldPosition);
            BlockPos pos = this.worldPosition;
            for (int i = 0; i < 5 && state.getBlock() instanceof MultiblockPart.MultiblockGhostPart; ++i) {
                Direction d2 = ((MultiblockPart.MultiblockGhostPart)state.getBlock()).getParentDir(state);
                pos = pos.relative(d2, 1);
                state = this.level.getBlockState(pos);
            }
            if (state.getBlock() instanceof MultiblockPart && !((d = (MultiblockPart)state.getBlock()) instanceof MultiblockPart.MultiblockGhostPart) && (te = this.level.getBlockEntity(pos)) instanceof MultiblockCapHandler) {
                return ((MultiblockCapHandler)te).getCaps(cap, this.type);
            }
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockState state = this.level.getBlockState(this.worldPosition);
        BlockPos pos = this.worldPosition;
        for (int i = 0; i < 5 && state.getBlock() instanceof MultiblockPart.MultiblockGhostPart; ++i) {
            Direction d = ((MultiblockPart.MultiblockGhostPart)state.getBlock()).getParentDir(state);
            pos = pos.relative(d, 1);
            state = this.level.getBlockState(pos);
        }
        if (state.getBlock() instanceof MultiblockPart) {
            MultiblockPart d = (MultiblockPart)state.getBlock();
            if (d instanceof MultiblockPart.MultiblockGhostPart) {
                return false;
            }
            BlockEntity te = this.level.getBlockEntity(pos);
            if (te instanceof MultiblockCapHandler) {
                return ((MultiblockCapHandler)te).addToGoggleTooltip(tooltip, isPlayerSneaking);
            }
            return false;
        }
        return false;
    }
}

