/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.client;

import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import win.demistorm.ConfigHelper;
import win.demistorm.VRThrowingExtensions;

public final class AimHelper {
    private static final double maxAssistDistance = 25.0;
    private static final double assistViewAngle = 35.0;
    private static final double assistStrength = 0.5;
    private static final double maxPredictionTime = 2.5;
    private static final double gravityCalc = 0.06;
    private static final double ticksPerSecond = 20.0;

    public static Vec3 applyAimAssist(LocalPlayer player, Vec3 origin, Vec3 originalVelocity) {
        VRThrowingExtensions.log.debug("[Aim Assist] Checking ACTIVE.aimAssist = {}, CLIENT.aimAssist = {}", (Object)ConfigHelper.ACTIVE.aimAssist, (Object)ConfigHelper.CLIENT.aimAssist);
        if (!ConfigHelper.ACTIVE.aimAssist) {
            VRThrowingExtensions.log.debug("[Aim Assist] Aim assist is DISABLED by server config - returning original velocity");
            return originalVelocity;
        }
        Optional<TargetInfo> bestTarget = AimHelper.findBestTarget(player, origin, originalVelocity);
        if (bestTarget.isEmpty()) {
            VRThrowingExtensions.log.debug("[Aim Assist] No suitable target found");
            return originalVelocity;
        }
        TargetInfo target = bestTarget.get();
        Vec3 assistedVelocity = AimHelper.calculateBallisticAssist(origin, originalVelocity, target);
        double adjustment = assistedVelocity.subtract(originalVelocity).length();
        VRThrowingExtensions.log.debug("[Aim Assist] Target: {}, distance: {}, time: {}s, adjustment: {}", new Object[]{target.entity.getName().getString(), target.distance, target.interceptTime, adjustment});
        return assistedVelocity;
    }

    private static Optional<TargetInfo> findBestTarget(LocalPlayer player, Vec3 origin, Vec3 velocity) {
        Vec3 throwDirection = velocity.normalize();
        double throwSpeed = velocity.length();
        Vec3 min = origin.subtract(25.0, 25.0, 25.0);
        Vec3 max = origin.add(25.0, 25.0, 25.0);
        AABB searchBox = new AABB(min, max);
        List candidates = player.level().getEntitiesOfClass(LivingEntity.class, searchBox, entity -> entity != player && entity.isAlive() && !entity.isSpectator());
        TargetInfo bestTarget = null;
        double bestScore = 0.0;
        for (LivingEntity entity2 : candidates) {
            double score;
            TargetInfo targetInfo = AimHelper.evaluateTarget(entity2, origin, throwDirection, throwSpeed);
            if (targetInfo == null || !((score = AimHelper.calculateTargetScore(targetInfo)) > bestScore)) continue;
            bestScore = score;
            bestTarget = targetInfo;
        }
        return Optional.ofNullable(bestTarget);
    }

    private static TargetInfo evaluateTarget(LivingEntity entity, Vec3 origin, Vec3 throwDirection, double throwSpeed) {
        Vec3 targetPos = entity.position().add(0.0, (double)entity.getEyeHeight() / 1.5, 0.0);
        Vec3 toTarget = targetPos.subtract(origin);
        double distance = toTarget.length();
        if (distance > 25.0) {
            return null;
        }
        double angle = Math.toDegrees(Math.acos(Mth.clamp((double)throwDirection.dot(toTarget.normalize()), (double)-1.0, (double)1.0)));
        if (angle > 35.0) {
            return null;
        }
        Vec3 entityVelocity = entity.getDeltaMovement();
        double interceptTime = AimHelper.calculateOptimalInterceptTime(origin, targetPos, entityVelocity, throwSpeed);
        if (interceptTime < 0.0 || interceptTime > 2.5) {
            return null;
        }
        double tTicks = interceptTime * 20.0;
        Vec3 predictedPos = targetPos.add(entityVelocity.scale(tTicks));
        double trajectoryConfidence = AimHelper.calculateTrajectoryPossibility(origin, predictedPos, throwSpeed, interceptTime);
        if (trajectoryConfidence < 0.3) {
            return null;
        }
        return new TargetInfo(entity, targetPos, predictedPos, distance, angle, trajectoryConfidence, interceptTime);
    }

    private static double calculateOptimalInterceptTime(Vec3 origin, Vec3 targetPos, Vec3 targetVel, double throwSpeed) {
        double minTicks = 1.0;
        double maxTicks = 50.0;
        if (throwSpeed <= 1.0E-6) {
            return -1.0;
        }
        DoubleUnaryOperator speedErrorAtTicks = tTicks -> {
            if (tTicks <= 1.0E-6) {
                return Double.POSITIVE_INFINITY;
            }
            Vec3 predicted = targetPos.add(targetVel.scale(tTicks));
            double tSec = tTicks / 20.0;
            Vec3 requiredVel = AimHelper.calculateRequiredBallisticVelocity(origin, predicted, tSec);
            return requiredVel.length() - throwSpeed;
        };
        Vec3 r0 = targetPos.subtract(origin);
        double a = targetVel.lengthSqr() - throwSpeed * throwSpeed;
        double b = 2.0 * r0.dot(targetVel);
        double c = r0.lengthSqr();
        double tGuess = -1.0;
        double disc = b * b - 4.0 * a * c;
        if (Math.abs(a) < 1.0E-8) {
            double t;
            if (Math.abs(b) > 1.0E-8 && (t = -c / b) > 0.0) {
                tGuess = t;
            }
        } else if (disc >= 0.0) {
            double sqrt = Math.sqrt(disc);
            double t1 = (-b - sqrt) / (2.0 * a);
            double t2 = (-b + sqrt) / (2.0 * a);
            double best = Double.POSITIVE_INFINITY;
            if (t1 > 0.0) {
                best = Math.min(best, t1);
            }
            if (t2 > 0.0) {
                best = Math.min(best, t2);
            }
            if (Double.isFinite(best)) {
                tGuess = best;
            }
        }
        if (!(tGuess > 0.0)) {
            double linearDistance = r0.length();
            tGuess = Math.max(1.0, Math.min(50.0, linearDistance / Math.max(1.0E-6, throwSpeed)));
        } else {
            tGuess = Mth.clamp((double)tGuess, (double)1.0, (double)50.0);
        }
        int steps = 12;
        double prevT = 1.0;
        double prevErr = speedErrorAtTicks.applyAsDouble(prevT);
        double brLo = Double.NaN;
        double brHi = Double.NaN;
        double errLo = 0.0;
        for (int i = 1; i <= 12; ++i) {
            double alpha = (double)i / 12.0;
            double t = Mth.lerp((double)alpha, (double)1.0, (double)50.0);
            t = Mth.lerp((double)0.25, (double)t, (double)Mth.clamp((float)((float)tGuess), (float)1.0f, (float)50.0f));
            double err = speedErrorAtTicks.applyAsDouble(t);
            if (prevErr == 0.0 || err == 0.0 || prevErr < 0.0 && err > 0.0 || prevErr > 0.0 && err < 0.0) {
                brLo = Math.min(prevT, t);
                brHi = Math.max(prevT, t);
                errLo = brLo == prevT ? prevErr : err;
                break;
            }
            prevT = t;
            prevErr = err;
        }
        double absTol = Math.max(0.01, 0.03 * throwSpeed);
        if (Double.isFinite(brLo) && Double.isFinite(brHi)) {
            double lo = brLo;
            double hi = brHi;
            double fLo = errLo;
            for (int iter = 0; iter < 18; ++iter) {
                double mid = 0.5 * (lo + hi);
                double fMid = speedErrorAtTicks.applyAsDouble(mid);
                if (Math.abs(fMid) <= absTol) {
                    double solvedTicks = mid;
                    double errPct = Math.abs(fMid) / Math.max(1.0E-6, throwSpeed);
                    VRThrowingExtensions.log.debug("[Aim Assist] Intercept refined: T={} ticks (~{}s), err={} ({}%)", new Object[]{String.format("%.2f", solvedTicks), String.format("%.2f", solvedTicks / 20.0), String.format("%.4f", fMid), errPct * 100.0});
                    return solvedTicks / 20.0;
                }
                if (fLo < 0.0 && fMid > 0.0 || fLo > 0.0 && fMid < 0.0) {
                    hi = mid;
                    continue;
                }
                lo = mid;
                fLo = fMid;
            }
            double solvedTicks = 0.5 * (lo + hi);
            return solvedTicks / 20.0;
        }
        double[] testTimes = new double[]{Mth.clamp((double)(tGuess * 0.5), (double)1.0, (double)50.0), Mth.clamp((double)(tGuess * 0.75), (double)1.0, (double)50.0), Mth.clamp((double)tGuess, (double)1.0, (double)50.0), Mth.clamp((double)(tGuess * 1.25), (double)1.0, (double)50.0), Mth.clamp((double)(tGuess * 1.5), (double)1.0, (double)50.0)};
        double bestT = -1.0;
        double bestAbsErr = Double.MAX_VALUE;
        for (double t : testTimes) {
            double e = speedErrorAtTicks.applyAsDouble(t);
            double ae = Math.abs(e);
            if (!(ae < bestAbsErr)) continue;
            bestAbsErr = ae;
            bestT = t;
        }
        double relErr = bestAbsErr / Math.max(1.0E-6, throwSpeed);
        if (relErr <= 0.15) {
            VRThrowingExtensions.log.debug("[Aim Assist] Using close fallback time: T={} ticks (~{}s), relErr={}%", new Object[]{String.format("%.2f", bestT), String.format("%.2f", bestT / 20.0), relErr * 100.0});
            return bestT / 20.0;
        }
        VRThrowingExtensions.log.debug("[Aim Assist] No valid intercept (bestRelErr={}%)", (Object)String.format("%.1f", relErr * 100.0));
        return -1.0;
    }

    private static Vec3 calculateRequiredBallisticVelocity(Vec3 origin, Vec3 target, double flightTimeSeconds) {
        Vec3 displacement = target.subtract(origin);
        double flightTimeTicks = flightTimeSeconds * 20.0;
        double vx = displacement.x / flightTimeTicks;
        double vz = displacement.z / flightTimeTicks;
        double vy = (displacement.y + 0.03 * flightTimeTicks * flightTimeTicks) / flightTimeTicks;
        return new Vec3(vx, vy, vz);
    }

    private static double calculateTrajectoryPossibility(Vec3 origin, Vec3 target, double throwSpeed, double timeSeconds) {
        Vec3 requiredVel = AimHelper.calculateRequiredBallisticVelocity(origin, target, timeSeconds);
        double requiredSpeed = requiredVel.length();
        return Math.min(throwSpeed, requiredSpeed) / Math.max(throwSpeed, requiredSpeed);
    }

    private static Vec3 calculateBallisticAssist(Vec3 origin, Vec3 originalVelocity, TargetInfo target) {
        Vec3 idealVelocity = AimHelper.calculateRequiredBallisticVelocity(origin, target.predictedPos, target.interceptTime);
        double originalSpeed = originalVelocity.length();
        double idealSpeed = idealVelocity.length();
        if (idealSpeed > 1.0E-6) {
            idealVelocity = idealVelocity.scale(originalSpeed / idealSpeed);
        }
        if (idealVelocity.length() > originalSpeed * 1.6) {
            idealVelocity = idealVelocity.normalize().scale(originalSpeed * 1.6);
        }
        double effectiveStrength = 0.5 * target.confidence;
        return AimHelper.blendVelocities(originalVelocity, idealVelocity, effectiveStrength);
    }

    private static Vec3 blendVelocities(Vec3 current, Vec3 target, double strength) {
        return current.scale(1.0 - strength).add(target.scale(strength));
    }

    private static double calculateTargetScore(TargetInfo target) {
        double baseScore = target.confidence;
        double distanceScore = 1.0 - target.distance / 25.0;
        double angleScore = 1.0 - target.angle / 35.0;
        double typeMultiplier = 0.7;
        if (target.entity instanceof Monster) {
            typeMultiplier = 1.0;
        }
        if (target.entity instanceof Player) {
            typeMultiplier = 0.6;
        }
        return (baseScore + distanceScore + angleScore) / 3.0 * typeMultiplier;
    }

    private AimHelper() {
    }

    private record TargetInfo(LivingEntity entity, Vec3 currentPos, Vec3 predictedPos, double distance, double angle, double confidence, double interceptTime) {
    }
}

