/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.inventory.slots;

import com.google.gson.JsonObject;
import immersive_aircraft.entity.InventoryVehicleEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;

public class SlotDescription {
    protected final String type;
    protected final int index;
    protected final int x;
    protected final int y;

    public SlotDescription(String type, int index, int x, int y, JsonObject json) {
        this.type = type;
        this.index = index;
        this.x = x;
        this.y = y;
    }

    public SlotDescription(String type, RegistryFriendlyByteBuf buffer) {
        this.type = type;
        this.index = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
    }

    public Slot getSlot(InventoryVehicleEntity vehicle, Container inventory) {
        return new Slot(inventory, this.index, this.x, this.y);
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.index);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
    }

    public Optional<List<Component>> getToolTip() {
        return Optional.empty();
    }

    public String type() {
        return this.type;
    }

    public int index() {
        return this.index;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public static interface SlotDescriptionDecoder {
        public SlotDescription decode(String var1, RegistryFriendlyByteBuf var2);
    }

    public static interface SlotDescriptionFactory {
        public SlotDescription construct(String var1, int var2, int var3, int var4, JsonObject var5);
    }
}

