/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.client.gui.SlotRenderer;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.screen.VehicleScreenHandler;
import immersive_aircraft.util.Rect2iCommon;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class VehicleScreen
extends AbstractContainerScreen<VehicleScreenHandler> {
    private static final ResourceLocation TEXTURE = Main.locate("textures/gui/container/inventory.png");
    public static final int TITLE_HEIGHT = 10;
    public static final int BASE_HEIGHT = 86;
    public int containerSize;

    public VehicleScreen(VehicleScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.containerSize = handler.getVehicle().getInventoryDescription().getHeight();
        this.imageHeight = 86 + this.containerSize + 20;
        this.inventoryLabelY = this.containerSize + 10;
    }

    protected void drawRectangle(GuiGraphics context, int x, int y, int h, int w) {
        context.blit(TEXTURE, x, y, 176.0f, 0.0f, 16, 16, 512, 256);
        context.blit(TEXTURE, x + w - 16, y, 208.0f, 0.0f, 16, 16, 512, 256);
        context.blit(TEXTURE, x + w - 16, y + h - 16, 208.0f, 32.0f, 16, 16, 512, 256);
        context.blit(TEXTURE, x, y + h - 16, 176.0f, 32.0f, 16, 16, 512, 256);
        context.blit(TEXTURE, x + 16, y, w - 32, 16, 192.0f, 0.0f, 16, 16, 512, 256);
        context.blit(TEXTURE, x + 16, y + h - 16, w - 32, 16, 192.0f, 32.0f, 16, 16, 512, 256);
        context.blit(TEXTURE, x, y + 16, 16, h - 32, 176.0f, 16.0f, 16, 16, 512, 256);
        context.blit(TEXTURE, x + w - 16, y + 16, 16, h - 32, 208.0f, 16.0f, 16, 16, 512, 256);
        context.blit(TEXTURE, x + 16, y + 16, w - 32, h - 32, 192.0f, 16.0f, 16, 16, 512, 256);
    }

    public void drawImage(GuiGraphics context, int x, int y, int u, int v, int w, int h) {
        context.blit(TEXTURE, x, y, (float)u, (float)v, w, h, 512, 256);
    }

    protected void renderBg(@NotNull GuiGraphics context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.containerSize + 20, 512, 256);
        context.blit(TEXTURE, this.leftPos, this.topPos + this.containerSize + 20 - 4, 0.0f, 136.0f, this.imageWidth, 86, 512, 256);
        for (Rect2iCommon rectangle : ((VehicleScreenHandler)this.menu).getVehicle().getInventoryDescription().getRectangles()) {
            this.drawRectangle(context, this.leftPos + rectangle.getX(), this.topPos + rectangle.getY(), rectangle.getHeight(), rectangle.getWidth());
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        for (SlotDescription slot : ((VehicleScreenHandler)this.menu).getVehicle().getInventoryDescription().getSlots()) {
            SlotRenderer.get(slot.type()).render(this, context, slot, mouseX, mouseY, delta);
        }
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem() && this.hoveredSlot.container == ((VehicleScreenHandler)this.menu).getVehicle().getInventory()) {
            SlotDescription slot = ((VehicleScreenHandler)this.menu).getVehicle().getInventoryDescription().getSlots().get(this.hoveredSlot.getContainerSlot());
            slot.getToolTip().ifPresent(tooltip -> context.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY));
        } else {
            this.renderTooltip(context, mouseX, mouseY);
        }
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        if (super.hasClickedOutside(mouseX, mouseY, left, top, button)) {
            for (Rect2iCommon rectangle : ((VehicleScreenHandler)this.menu).getVehicle().getInventoryDescription().getRectangles()) {
                if (!(mouseX > (double)(rectangle.getX() + this.leftPos)) || !(mouseX < (double)(rectangle.getX() + rectangle.getWidth() + this.leftPos)) || !(mouseY > (double)(rectangle.getY() + this.topPos)) || !(mouseY < (double)(rectangle.getY() + rectangle.getHeight() + this.topPos))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getX() {
        return this.leftPos;
    }

    public int getY() {
        return this.topPos;
    }
}

