/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.registry;

import com.robocraft999.creategoggles.CreateGoggles;
import com.robocraft999.creategoggles.item.ArmorColor;
import com.robocraft999.creategoggles.item.backtank.DyableBacktankItem;
import com.robocraft999.creategoggles.item.goggle.CardboardGoggleHelmet;
import com.robocraft999.creategoggles.item.goggle.DivingGoggleHelmet;
import com.robocraft999.creategoggles.item.goggle.DyableGoggleHelmet;
import com.robocraft999.creategoggles.item.goggle.GoggleHelmet;
import com.robocraft999.creategoggles.item.goggle.IGoggleHelmet;
import com.robocraft999.creategoggles.item.modifier.CGSmithingTemplateItem;
import com.robocraft999.creategoggles.registry.CGBlocks;
import com.robocraft999.creategoggles.registry.CGTags;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.armor.AllArmorMaterials;
import com.simibubi.create.content.equipment.armor.BacktankBlock;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.foundation.data.AssetLookup;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.block.Block;

public class CGItems {
    public static final ItemEntry<? extends IGoggleHelmet> CHAINMAIL_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> DIAMOND_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> GOLDEN_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> IRON_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> TURTLE_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> NETHERITE_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> LEATHER_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> DIVING_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> NETHERITE_DIVING_GOGGLE_HELMET;
    public static final ItemEntry<? extends IGoggleHelmet> CARDBOARD_GOGGLE_HELMET;
    public static final ItemEntry<BacktankItem.BacktankBlockItem> CHAINMAIL_BACKTANK_PLACEABLE;
    public static final ItemEntry<BacktankItem.BacktankBlockItem> DIAMOND_BACKTANK_PLACABLE;
    public static final ItemEntry<BacktankItem.BacktankBlockItem> GOLDEN_BACKTANK_PLACEABLE;
    public static final ItemEntry<BacktankItem.BacktankBlockItem> IRON_BACKTANK_PLACEABLE;
    public static final ItemEntry<BacktankItem.BacktankBlockItem> LEATHER_BACKTANK_PLACEABLE;
    public static final ItemEntry<? extends BacktankItem> CHAINMAIL_BACKTANK;
    public static final ItemEntry<? extends BacktankItem> DIAMOND_BACKTANK;
    public static final ItemEntry<? extends BacktankItem> GOLDEN_BACKTANK;
    public static final ItemEntry<? extends BacktankItem> IRON_BACKTANK;
    public static final ItemEntry<? extends BacktankItem> LEATHER_BACKTANK;
    public static final ItemEntry<Item> MODIFIER_REMOVER;
    public static final ItemEntry<SmithingTemplateItem> GOGGLE_ARMOR_TRIM_SMITHING_TEMPLATE;

    private static ItemEntry<? extends GoggleHelmet> goggleHelmet(String name, Holder<ArmorMaterial> material, int durability) {
        return CGItems.goggleHelmet(name, p -> new GoggleHelmet(material, p.durability(ArmorItem.Type.HELMET.getDurability(durability)), CGItems.vanillaArmorLoc(material))).register();
    }

    private static <T extends Item> ItemBuilder<T, ?> goggleHelmet(String name, NonNullFunction<Item.Properties, T> builder) {
        return CreateGoggles.REGISTRATE.item(name, builder).tag(new TagKey[]{CGTags.Items.GOGGLE}).tag(new TagKey[]{ItemTags.TRIMMABLE_ARMOR}).tag(new TagKey[]{ItemTags.HEAD_ARMOR});
    }

    private static ItemEntry<BacktankItem.BacktankBlockItem> backtank_placable(String name, Supplier<ItemEntry<? extends BacktankItem>> item, Supplier<BlockEntry<? extends BacktankBlock>> block) {
        return CreateGoggles.REGISTRATE.item(name + "_placeable", p -> new BacktankItem.BacktankBlockItem((Block)((BlockEntry)block.get()).get(), () -> ((ItemEntry)((ItemEntry)item.get())).get(), p)).model(AssetLookup.existingItemModel()).register();
    }

    private static ItemEntry<? extends BacktankItem> backtank(String name, Holder<ArmorMaterial> material, ItemEntry<BacktankItem.BacktankBlockItem> placable) {
        return CreateGoggles.REGISTRATE.item(name, p -> new BacktankItem(material, p, CGItems.vanillaArmorLoc(material), (Supplier)placable)).model(AssetLookup.customGenericItemModel((String[])new String[]{"_", "item"})).tag(new TagKey[]{AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.tag}).tag(new TagKey[]{ItemTags.TRIMMABLE_ARMOR}).tag(new TagKey[]{ItemTags.CHEST_ARMOR}).register();
    }

    private static ResourceLocation vanillaArmorLoc(Holder<ArmorMaterial> material) {
        return ResourceLocation.parse((String)material.getRegisteredName());
    }

    public static void register() {
        GogglesItem.addIsWearingPredicate(IGoggleHelmet::isGoggleHelmet);
    }

    static {
        CreateGoggles.LOGGER.info("cgitems");
        CHAINMAIL_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_chainmail_helmet", (Holder<ArmorMaterial>)ArmorMaterials.CHAIN, 15);
        DIAMOND_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_diamond_helmet", (Holder<ArmorMaterial>)ArmorMaterials.DIAMOND, 33);
        GOLDEN_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_golden_helmet", (Holder<ArmorMaterial>)ArmorMaterials.GOLD, 7);
        IRON_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_iron_helmet", (Holder<ArmorMaterial>)ArmorMaterials.IRON, 15);
        TURTLE_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_turtle_helmet", (Holder<ArmorMaterial>)ArmorMaterials.TURTLE, 25);
        NETHERITE_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_netherite_helmet", p -> new GoggleHelmet((Holder<ArmorMaterial>)ArmorMaterials.NETHERITE, p.fireResistant().durability(ArmorItem.Type.HELMET.getDurability(37)), CGItems.vanillaArmorLoc((Holder<ArmorMaterial>)ArmorMaterials.NETHERITE))).register();
        LEATHER_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_leather_helmet", p -> new DyableGoggleHelmet((Holder<ArmorMaterial>)ArmorMaterials.LEATHER, p.durability(ArmorItem.Type.HELMET.getDurability(5)), CGItems.vanillaArmorLoc((Holder<ArmorMaterial>)ArmorMaterials.LEATHER))).model(AssetLookup.existingItemModel()).tag(new TagKey[]{ItemTags.DYEABLE}).color(() -> ArmorColor::new).register();
        DIVING_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_diving_helmet", p -> new DivingGoggleHelmet((Holder<ArmorMaterial>)AllArmorMaterials.COPPER, p.durability(ArmorItem.Type.HELMET.getDurability(7)), Create.asResource((String)"copper_diving"))).register();
        NETHERITE_DIVING_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_netherite_diving_helmet", p -> new DivingGoggleHelmet((Holder<ArmorMaterial>)ArmorMaterials.NETHERITE, p.fireResistant().durability(ArmorItem.Type.HELMET.getDurability(37)), Create.asResource((String)"netherite_diving"))).register();
        CARDBOARD_GOGGLE_HELMET = CGItems.goggleHelmet("goggle_cardboard_helmet", p -> new CardboardGoggleHelmet(p.durability(ArmorItem.Type.HELMET.getDurability(4)))).register();
        CHAINMAIL_BACKTANK_PLACEABLE = CGItems.backtank_placable("chainmail_backtank", () -> CHAINMAIL_BACKTANK, () -> CGBlocks.CHAINMAIL_BACKTANK_BLOCK);
        DIAMOND_BACKTANK_PLACABLE = CGItems.backtank_placable("diamond_backtank", () -> DIAMOND_BACKTANK, () -> CGBlocks.DIAMOND_BACKTANK_BLOCK);
        GOLDEN_BACKTANK_PLACEABLE = CGItems.backtank_placable("golden_backtank", () -> GOLDEN_BACKTANK, () -> CGBlocks.GOLDEN_BACKTANK_BLOCK);
        IRON_BACKTANK_PLACEABLE = CGItems.backtank_placable("iron_backtank", () -> IRON_BACKTANK, () -> CGBlocks.IRON_BACKTANK_BLOCK);
        LEATHER_BACKTANK_PLACEABLE = CGItems.backtank_placable("leather_backtank", () -> LEATHER_BACKTANK, () -> CGBlocks.LEATHER_BACKTANK_BLOCK);
        CHAINMAIL_BACKTANK = CGItems.backtank("chainmail_backtank", (Holder<ArmorMaterial>)ArmorMaterials.CHAIN, CHAINMAIL_BACKTANK_PLACEABLE);
        DIAMOND_BACKTANK = CGItems.backtank("diamond_backtank", (Holder<ArmorMaterial>)ArmorMaterials.DIAMOND, DIAMOND_BACKTANK_PLACABLE);
        GOLDEN_BACKTANK = CGItems.backtank("golden_backtank", (Holder<ArmorMaterial>)ArmorMaterials.GOLD, GOLDEN_BACKTANK_PLACEABLE);
        IRON_BACKTANK = CGItems.backtank("iron_backtank", (Holder<ArmorMaterial>)ArmorMaterials.IRON, IRON_BACKTANK_PLACEABLE);
        LEATHER_BACKTANK = CreateGoggles.REGISTRATE.item("leather_backtank", p -> new DyableBacktankItem((Holder<ArmorMaterial>)ArmorMaterials.LEATHER, (Item.Properties)p, ResourceLocation.withDefaultNamespace((String)"leather"), (Supplier<BacktankItem.BacktankBlockItem>)LEATHER_BACKTANK_PLACEABLE)).model(AssetLookup.customGenericItemModel((String[])new String[]{"_", "item"})).tag(new TagKey[]{AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.tag}).tag(new TagKey[]{ItemTags.CHEST_ARMOR}).tag(new TagKey[]{ItemTags.TRIMMABLE_ARMOR}).tag(new TagKey[]{ItemTags.DYEABLE}).register();
        MODIFIER_REMOVER = CreateGoggles.REGISTRATE.item("modifier_remover", Item::new).register();
        GOGGLE_ARMOR_TRIM_SMITHING_TEMPLATE = CreateGoggles.REGISTRATE.item("goggle_armor_trim_smithing_template", p -> CGSmithingTemplateItem.createGoggleArmorTrimTemplateItem()).tag(new TagKey[]{ItemTags.TRIM_TEMPLATES}).lang("Smithing Template").register();
    }
}

