/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.recipe.requirements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.RecipeRequirementType;
import com.oierbravo.mechanicals.register.MechanicalRecipeRequirementTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;

public record BiomeTagRequirement(TagKey<Biome> tag) implements IRecipeRequirement
{
    public static String ID = "biome_tag";
    public static MapCodec<BiomeTagRequirement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.optionalFieldOf("value", null).forGetter(BiomeTagRequirement::getResourceLocation)).apply((Applicative)builder, BiomeTagRequirement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BiomeTagRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, BiomeTagRequirement::getResourceLocation, BiomeTagRequirement::new);

    public BiomeTagRequirement(ResourceLocation resourceLocation) {
        this((TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)resourceLocation));
    }

    public ResourceLocation getResourceLocation() {
        return this.tag.location();
    }

    public static BiomeTagRequirement of(TagKey<Biome> tag) {
        return new BiomeTagRequirement(tag);
    }

    public static BiomeTagRequirement of(ResourceLocation resourceLocation) {
        return BiomeTagRequirement.of((TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)resourceLocation));
    }

    public static BiomeTagRequirement of(String id) {
        return new BiomeTagRequirement(ResourceLocation.parse((String)id));
    }

    @Override
    public boolean test(Level pLevel, BlockEntity pBlockEntity) {
        if (this.tag == null) {
            return true;
        }
        Holder blockEntityBiome = pLevel.getBiome(pBlockEntity.getBlockPos());
        if (pLevel.isClientSide()) {
            return false;
        }
        return pLevel.getServer().registryAccess().registryOrThrow(Registries.BIOME).getTag(this.tag).map(t -> t.contains(blockEntityBiome)).orElse(false);
    }

    @Override
    public RecipeRequirementType<?> getType() {
        return MechanicalRecipeRequirementTypes.BIOME_TAG.get();
    }

    @Override
    public String getIdString() {
        return ID;
    }

    @Override
    public String toString() {
        return this.tag.location().toString();
    }
}

