/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.neoforge.mixin;

import me.itzme1on.alcocraftplus.core.mixin.AttractTracked;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements AttractTracked {
    @Unique
    private static final EntityDataAccessor<Integer> ATTRACTOR_ID = SynchedEntityData.defineId(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Unique
    private static final EntityDataAccessor<Float> ATTRACT_ACCELERATION_X = SynchedEntityData.defineId(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    @Unique
    private static final EntityDataAccessor<Float> ATTRACT_ACCELERATION_Y = SynchedEntityData.defineId(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    @Unique
    private static final EntityDataAccessor<Float> ATTRACT_ACCELERATION_Z = SynchedEntityData.defineId(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    @Unique
    private static final EntityDataAccessor<Integer> ATTRACT_TTL = SynchedEntityData.defineId(ItemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected ItemEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    private void alcocraftplus$defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(ATTRACTOR_ID, (Object)0);
        builder.define(ATTRACT_ACCELERATION_X, (Object)Float.valueOf(0.0f));
        builder.define(ATTRACT_ACCELERATION_Y, (Object)Float.valueOf(0.0f));
        builder.define(ATTRACT_ACCELERATION_Z, (Object)Float.valueOf(0.0f));
        builder.define(ATTRACT_TTL, (Object)0);
    }

    @Override
    public int alcocraftplus$getAttractorId() {
        return (Integer)this.entityData.get(ATTRACTOR_ID);
    }

    @Override
    public void alcocraftplus$setAttractorId(int id) {
        this.entityData.set(ATTRACTOR_ID, (Object)id);
    }

    @Override
    public Vec3 alcocraftplus$getAttractAccel() {
        return new Vec3((double)((Float)this.entityData.get(ATTRACT_ACCELERATION_X)).floatValue(), (double)((Float)this.entityData.get(ATTRACT_ACCELERATION_Y)).floatValue(), (double)((Float)this.entityData.get(ATTRACT_ACCELERATION_Z)).floatValue());
    }

    @Override
    public void alcocraftplus$setAttractAccel(Vec3 vec) {
        this.entityData.set(ATTRACT_ACCELERATION_X, (Object)Float.valueOf((float)vec.x));
        this.entityData.set(ATTRACT_ACCELERATION_Y, (Object)Float.valueOf((float)vec.y));
        this.entityData.set(ATTRACT_ACCELERATION_Z, (Object)Float.valueOf((float)vec.z));
    }

    @Override
    public int alcocraftplus$getAttractTtl() {
        return (Integer)this.entityData.get(ATTRACT_TTL);
    }

    @Override
    public void alcocraftplus$setAttractTtl(int ticks) {
        this.entityData.set(ATTRACT_TTL, (Object)ticks);
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void alcocraftplus$serverResetAccel(CallbackInfo ci) {
        if (this.level().isClientSide) {
            return;
        }
        int ttl = this.alcocraftplus$getAttractTtl();
        if (ttl > 0) {
            this.alcocraftplus$setAttractTtl(ttl - 1);
        }
        if (this.alcocraftplus$getAttractTtl() <= 0) {
            this.alcocraftplus$setAttractAccel(Vec3.ZERO);
            this.alcocraftplus$setAttractorId(0);
        }
    }
}

