/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class BeerTypeMapperUtil {
    private static final Map<Item, Integer> BEER_TYPE_MAP;
    private static final Map<Integer, ItemStack> BEER_ITEM_MAP;

    private BeerTypeMapperUtil() {
    }

    public static int getBeerType(Item item) {
        return BEER_TYPE_MAP.getOrDefault(item, 0);
    }

    public static ItemStack getBeerStack(int beerType) {
        return BEER_ITEM_MAP.getOrDefault(beerType, ItemStack.EMPTY);
    }

    static {
        HashMap<Item, Integer> type = new HashMap<Item, Integer>();
        type.put((Item)ItemsRegistry.SUN_PALE_ALE.get(), 1);
        type.put((Item)ItemsRegistry.DIGGER_BITTER.get(), 2);
        type.put((Item)ItemsRegistry.NETHER_PORTER.get(), 3);
        type.put((Item)ItemsRegistry.WITHER_STOUT.get(), 4);
        type.put((Item)ItemsRegistry.MAGNET_PILSNER.get(), 5);
        type.put((Item)ItemsRegistry.DROWNED_ALE.get(), 6);
        type.put((Item)ItemsRegistry.NIGHT_RAUCH.get(), 7);
        type.put((Item)ItemsRegistry.ICE_BEER.get(), 8);
        type.put((Item)ItemsRegistry.KVASS.get(), 9);
        type.put((Item)ItemsRegistry.LEPRECHAUN_CIDER.get(), 10);
        type.put((Item)ItemsRegistry.CHORUS_ALE.get(), 11);
        type.put((Item)ItemsRegistry.NETHER_STAR_LAGER.get(), 12);
        BEER_TYPE_MAP = Collections.unmodifiableMap(type);
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        items.put(1, new ItemStack((ItemLike)ItemsRegistry.SUN_PALE_ALE.get()));
        items.put(2, new ItemStack((ItemLike)ItemsRegistry.DIGGER_BITTER.get()));
        items.put(3, new ItemStack((ItemLike)ItemsRegistry.NETHER_PORTER.get()));
        items.put(4, new ItemStack((ItemLike)ItemsRegistry.WITHER_STOUT.get()));
        items.put(5, new ItemStack((ItemLike)ItemsRegistry.MAGNET_PILSNER.get()));
        items.put(6, new ItemStack((ItemLike)ItemsRegistry.DROWNED_ALE.get()));
        items.put(7, new ItemStack((ItemLike)ItemsRegistry.NIGHT_RAUCH.get()));
        items.put(8, new ItemStack((ItemLike)ItemsRegistry.ICE_BEER.get()));
        items.put(9, new ItemStack((ItemLike)ItemsRegistry.KVASS.get()));
        items.put(10, new ItemStack((ItemLike)ItemsRegistry.LEPRECHAUN_CIDER.get()));
        items.put(11, new ItemStack((ItemLike)ItemsRegistry.CHORUS_ALE.get()));
        items.put(12, new ItemStack((ItemLike)ItemsRegistry.NETHER_STAR_LAGER.get()));
        BEER_ITEM_MAP = Collections.unmodifiableMap(items);
    }
}

