/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.registries;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import me.itzme1on.alcocraftplus.core.blocks.hop.Hop;
import me.itzme1on.alcocraftplus.core.blocks.hop.HopPlant;
import me.itzme1on.alcocraftplus.core.blocks.keg.Keg;
import me.itzme1on.alcocraftplus.core.blocks.mugs.AlcoDrink;
import me.itzme1on.alcocraftplus.core.blocks.mugs.MugBlock;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import me.itzme1on.alcocraftplus.core.registries.ParticlesRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlocksRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"alcocraftplus", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<Block> HOP = BlocksRegistry.registerBlockWithoutItem("hop", () -> new Hop(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAVE_VINES).lightLevel(CaveVines.emission((int)0)).noOcclusion()));
    public static final RegistrySupplier<Block> HOP_PLANT = BlocksRegistry.registerBlockWithoutItem("hop_plant", () -> new HopPlant(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAVE_VINES).lightLevel(CaveVines.emission((int)0)).noOcclusion()));
    public static final RegistrySupplier<Block> MUG = BlocksRegistry.registerBlockWithoutItem("mug", MugBlock::new);
    public static final RegistrySupplier<Block> KEG = BlocksRegistry.registerBlock("keg", () -> new Keg(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL).noOcclusion()));
    public static final RegistrySupplier<Block> KVASS = BlocksRegistry.registerBlockWithoutItem("kvass", () -> new AlcoDrink(() -> ParticlesRegistry.YELLOW_BUBBLE.get()));
    public static final RegistrySupplier<Block> CHORUS_ALE = BlocksRegistry.registerBlockWithoutItem("chorus_ale", () -> new AlcoDrink(() -> ParticleTypes.PORTAL){

        @Override
        public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
            if (random.nextFloat() < 0.4f) {
                for (int i = 0; i < 3; ++i) {
                    int j = random.nextInt(2) * 2 - 1;
                    int k = random.nextInt(2) * 2 - 1;
                    double d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                    double d1 = (float)pos.getY() + random.nextFloat();
                    double d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)k;
                    double d3 = random.nextFloat() * (float)j;
                    double d4 = ((double)random.nextFloat() - 0.5) * 0.125;
                    double d5 = random.nextFloat() * (float)k;
                    level.addParticle(this.getParticle(), d0, d1, d2, d3, d4, d5);
                }
            }
        }
    });
    public static final RegistrySupplier<Block> DIGGER_BITTER = BlocksRegistry.registerBlockWithoutItem("digger_bitter", () -> new AlcoDrink(() -> ParticlesRegistry.YELLOW_BUBBLE.get()));
    public static final RegistrySupplier<Block> DROWNED_ALE = BlocksRegistry.registerBlockWithoutItem("drowned_ale", MugBlock::new);
    public static final RegistrySupplier<Block> ICE_BEER = BlocksRegistry.registerBlockWithoutItem("ice_beer", () -> new AlcoDrink(() -> ParticlesRegistry.YELLOW_BUBBLE.get()));
    public static final RegistrySupplier<Block> LEPRECHAUN_CIDER = BlocksRegistry.registerBlockWithoutItem("leprechaun_cider", MugBlock::new);
    public static final RegistrySupplier<Block> MAGNET_PILSNER = BlocksRegistry.registerBlockWithoutItem("magnet_pilsner", MugBlock::new);
    public static final RegistrySupplier<Block> NETHER_PORTER = BlocksRegistry.registerBlockWithoutItem("nether_porter", MugBlock::new);
    public static final RegistrySupplier<Block> NETHER_STAR_LAGER = BlocksRegistry.registerBlockWithoutItem("nether_star_lager", () -> new AlcoDrink(() -> ParticleTypes.FIREWORK){

        @Override
        public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
            if (random.nextFloat() < 0.5f) {
                double d0 = (double)pos.getX() + 0.4 + random.nextDouble() * 0.2;
                double d1 = (double)pos.getY() + 0.2 + random.nextDouble() * 0.18000000000000002;
                double d2 = (double)pos.getZ() + 0.4 + random.nextDouble() * 0.2;
                level.addParticle(this.getParticle(), d0, d1, d2, 0.0, random.nextDouble() * 0.1, 0.0);
            }
        }
    });
    public static final RegistrySupplier<Block> NIGHT_RAUCH = BlocksRegistry.registerBlockWithoutItem("night_rauch", MugBlock::new);
    public static final RegistrySupplier<Block> SUN_PALE_ALE = BlocksRegistry.registerBlockWithoutItem("sun_pale_ale", () -> new AlcoDrink(() -> ParticlesRegistry.YELLOW_BUBBLE.get()));
    public static final RegistrySupplier<Block> WITHER_STOUT = BlocksRegistry.registerBlockWithoutItem("wither_stout", MugBlock::new);

    private BlocksRegistry() {
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        BlocksRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Block> registerBlockWithoutItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block) {
        return ItemsRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register() {
        BLOCKS.register();
    }
}

