/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.loot;

import dev.architectury.event.events.common.LootEvent;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import me.itzme1on.alcocraftplus.core.utils.IdentifierUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootModifier {
    public static void injectLoot(ResourceKey<LootTable> key, LootEvent.LootTableModificationContext context) {
        ResourceLocation id = key.location();
        String namespace = id.getNamespace();
        String path = id.getPath();
        if (namespace.equals("minecraft")) {
            switch (path) {
                case "blocks/grass": 
                case "blocks/short_grass": 
                case "blocks/tall_grass": {
                    LootModifier.modifyGrassLootTable(context);
                    break;
                }
                case "chests/abandoned_mineshaft": 
                case "chests/bastion_treasure": 
                case "chests/end_city_treasure": 
                case "chests/igloo_chest": 
                case "chests/nether_bridge": 
                case "chests/pillager_outpost": 
                case "chests/ruined_portal": 
                case "chests/shipwreck_supply": 
                case "chests/simple_dungeon": 
                case "chests/underwater_ruin_big": 
                case "chests/underwater_ruin_small": {
                    context.addPool(LootModifier.getPool(path.substring("chests/".length())));
                    break;
                }
            }
        }
    }

    public static void modifyGrassLootTable(LootEvent.LootTableModificationContext context) {
        LootPool.Builder builder = LootPool.lootPool().when(LootItemRandomChanceCondition.randomChance((float)0.07f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.HOP_SEEDS.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)));
        context.addPool(builder);
    }

    public static LootPool.Builder getPool(String entryName) {
        return LootPool.lootPool().add(LootModifier.getPoolEntry(entryName));
    }

    private static LootPoolEntryContainer.Builder<?> getPoolEntry(String name) {
        ResourceKey table = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)IdentifierUtil.of("chests/" + name));
        return NestedLootTable.lootTableReference((ResourceKey)table);
    }
}

