/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.effects;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class WitherEffect
extends MobEffect {
    public WitherEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level = entity.level();
        if (level.isClientSide()) {
            return true;
        }
        LivingEntity attacker = entity.getLastHurtByMob();
        if (attacker != null && attacker.isAlive()) {
            double radius = 50.0;
            if (attacker.distanceToSqr((Entity)entity) <= radius * radius) {
                attacker.addEffect(new MobEffectInstance(MobEffects.WITHER, 40, 5));
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int interval = 10;
        return duration % interval == 0;
    }
}

