/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.effects;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.itzme1on.alcocraftplus.core.mixin.AttractTracked;
import me.itzme1on.alcocraftplus.core.registries.EffectsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class AttractEffect
extends MobEffect {
    private static final long PARTICLE_INTERVAL_TICKS = 20L;
    private static final double PARTICLES_PER_BLOCK = 2.0;
    private static final DustParticleOptions DUST_COLOR = new DustParticleOptions(new Vector3f(0.6666667f, 0.05490196f, 0.003921569f), 0.5f);
    private static final double SEARCH_RADIUS_BLOCKS = 15.0;
    private static final double ATTRACT_RING_RADIUS_BLOCKS = 1.0;
    private static final double EPSILON = 1.0E-4;
    private static final double MAX_VERTICAL_DELTA = 0.35;
    private static Holder<MobEffect> ATTRACT_HOLDER;

    public AttractEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    private static Holder<MobEffect> attractHolder() {
        if (ATTRACT_HOLDER == null) {
            ATTRACT_HOLDER = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)EffectsRegistry.ATTRACT.get()));
        }
        return ATTRACT_HOLDER;
    }

    private static Set<ItemEntity> selectParticleSources(List<ItemEntity> nearbyItems, List<LivingEntity> attractEffectHolders, LivingEntity contextHolder) {
        HashMap<BlockPos, ItemEntity> bestItemByBlock = new HashMap<BlockPos, ItemEntity>();
        HashMap<BlockPos, Double> bestDist2ByBlock = new HashMap<BlockPos, Double>();
        if (attractEffectHolders.isEmpty()) {
            return Collections.emptySet();
        }
        for (ItemEntity item : nearbyItems) {
            LivingEntity nearest;
            if (!item.isAlive() || item.tickCount < 20 || (nearest = AttractEffect.findNearest(attractEffectHolders, item)) == null || nearest.getId() != contextHolder.getId()) continue;
            double distanceToItem = AttractEffect.squaredDistanceFeetToItem(nearest, item);
            BlockPos key = item.blockPosition();
            Double best = (Double)bestDist2ByBlock.get(key);
            if (best != null && !(distanceToItem < best)) continue;
            bestDist2ByBlock.put(key, distanceToItem);
            bestItemByBlock.put(key, item);
        }
        return new HashSet<ItemEntity>(bestItemByBlock.values());
    }

    private static LivingEntity findNearest(List<LivingEntity> holders, ItemEntity item) {
        LivingEntity nearest = null;
        double bestDist2 = Double.MAX_VALUE;
        for (LivingEntity h : holders) {
            double d2 = AttractEffect.squaredDistanceFeetToItem(h, item);
            if (!(d2 < bestDist2)) continue;
            bestDist2 = d2;
            nearest = h;
        }
        return nearest;
    }

    private static Vec3 itemCenter(ItemEntity item) {
        return new Vec3(item.getX(), item.getY() + (double)item.getBbHeight() * 0.5, item.getZ());
    }

    private static Vec3 entityFeet(LivingEntity e) {
        return new Vec3(e.getX(), e.getY() + 0.05, e.getZ());
    }

    private static Vec3 entityWaist(LivingEntity e) {
        return new Vec3(e.getX(), e.getY() + (double)e.getBbHeight() * 0.5, e.getZ());
    }

    private static double squaredDistanceFeetToItem(LivingEntity e, ItemEntity item) {
        Vec3 feet = AttractEffect.entityFeet(e);
        Vec3 center = AttractEffect.itemCenter(item);
        double dx = feet.x - center.x;
        double dy = feet.y - center.y;
        double dz = feet.z - center.z;
        return dx * dx + dy * dy + dz * dz;
    }

    private static Vec3 sphericalTargetAroundFeet(ItemEntity item, LivingEntity target) {
        Vec3 from = AttractEffect.itemCenter(item);
        Vec3 to = AttractEffect.entityFeet(target);
        return AttractEffect.computeRingPointTowardTarget(from, to);
    }

    private static Vec3 sphericalTargetAroundWaist(ItemEntity item, LivingEntity target) {
        Vec3 from = AttractEffect.itemCenter(item);
        Vec3 to = AttractEffect.entityWaist(target);
        return AttractEffect.computeRingPointTowardTarget(from, to);
    }

    @NotNull
    private static Vec3 computeRingPointTowardTarget(Vec3 from, Vec3 to) {
        Vec3 diff = to.subtract(from);
        double len = Math.max(diff.length(), 1.0E-4);
        Vec3 unit = diff.scale(1.0 / len);
        return new Vec3(to.x - unit.x * 1.0, to.y - unit.y * 1.0, to.z - unit.z * 1.0);
    }

    private static void spawnDustLine(ServerLevel level, Vec3 from, Vec3 to) {
        double distance = from.distanceTo(to);
        int points = Mth.clamp((int)((int)Math.floor(distance * 2.0) + 1), (int)1, (int)200);
        if (points <= 1 || distance < 1.0E-6) {
            return;
        }
        double stepX = (to.x - from.x) / (double)(points - 1);
        double stepY = (to.y - from.y) / (double)(points - 1);
        double stepZ = (to.z - from.z) / (double)(points - 1);
        double x = from.x;
        double y = from.y;
        double z = from.z;
        for (int i = 0; i < points; ++i) {
            level.sendParticles((ParticleOptions)DUST_COLOR, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            x += stepX;
            y += stepY;
            z += stepZ;
        }
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level = entity.level();
        if (level.isClientSide) {
            return true;
        }
        AABB searchBox = entity.getBoundingBox().inflate(15.0);
        List nearbyItems = level.getEntitiesOfClass(ItemEntity.class, searchBox);
        List<LivingEntity> attractEffectHolders = level.getEntitiesOfClass(LivingEntity.class, searchBox).stream().filter(e -> e.isAlive() && e.hasEffect(AttractEffect.attractHolder())).toList();
        if (attractEffectHolders.isEmpty() || nearbyItems.isEmpty()) {
            return true;
        }
        Set<ItemEntity> particleSources = AttractEffect.selectParticleSources(nearbyItems, attractEffectHolders, entity);
        HashMap<Integer, Integer> amplifierByHolderId = new HashMap<Integer, Integer>();
        for (LivingEntity holder : attractEffectHolders) {
            MobEffectInstance inst = holder.getEffect(AttractEffect.attractHolder());
            amplifierByHolderId.put(holder.getId(), inst == null ? 0 : inst.getAmplifier());
        }
        for (ItemEntity item : nearbyItems) {
            Vec3 velocity;
            if (!item.isAlive() || item.tickCount < 20) continue;
            LivingEntity nearestHolder = AttractEffect.findNearest(attractEffectHolders, item);
            if (item instanceof AttractTracked) {
                AttractTracked trackedId = (AttractTracked)item;
                trackedId.alcocraftplus$setAttractorId(nearestHolder != null ? nearestHolder.getId() : 0);
            }
            if (nearestHolder == null || entity.getId() != nearestHolder.getId()) continue;
            Vec3 itemCenter = AttractEffect.itemCenter(item);
            Vec3 holderFeet = AttractEffect.entityFeet(nearestHolder);
            Vec3 toFeet = holderFeet.subtract(itemCenter);
            double distanceToFeet = Math.max(toFeet.length(), 1.0E-4);
            Vec3 updatedVelocity = velocity = item.getDeltaMovement();
            if (distanceToFeet <= 1.0) {
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                if (!particleSources.contains(item) || serverLevel.getGameTime() % 20L != 0L) continue;
                Vec3 waistTarget = AttractEffect.sphericalTargetAroundWaist(item, nearestHolder);
                AttractEffect.spawnDustLine(serverLevel, itemCenter, waistTarget);
                continue;
            }
            Vec3 weightedDirectionSum = Vec3.ZERO;
            double totalWeight = 0.0;
            for (LivingEntity holder : attractEffectHolders) {
                double feetDistance;
                Vec3 targetPoint = AttractEffect.sphericalTargetAroundFeet(item, holder);
                Vec3 toTarget = targetPoint.subtract(itemCenter);
                double toTargetLength = toTarget.length();
                if (toTargetLength <= 1.0E-6 || (feetDistance = Math.sqrt(AttractEffect.squaredDistanceFeetToItem(holder, item))) > 15.0) continue;
                double closenessNorm = (15.0 - Math.min(feetDistance, 15.0)) / 15.0;
                double weight = closenessNorm * closenessNorm;
                totalWeight += weight;
                weightedDirectionSum = weightedDirectionSum.add(toTarget.scale(1.0 / toTargetLength * weight));
            }
            if (weightedDirectionSum.lengthSqr() > 1.0E-6) {
                Vec3 direction = weightedDirectionSum.normalize();
                double weightFactor = Math.min(totalWeight, 1.0);
                int nearestAmplifier = amplifierByHolderId.getOrDefault(nearestHolder.getId(), 0);
                double acceleration = 0.08 + 0.02 * (double)Math.max(0, nearestAmplifier);
                Vec3 deltaV = direction.scale(weightFactor * acceleration);
                if (deltaV.y > 0.35) {
                    deltaV = new Vec3(deltaV.x, 0.35, deltaV.z);
                }
                if (deltaV.y < -0.35) {
                    deltaV = new Vec3(deltaV.x, -0.35, deltaV.z);
                }
                updatedVelocity = velocity.add(deltaV);
            }
            if (updatedVelocity.y > 0.35) {
                updatedVelocity = new Vec3(updatedVelocity.x, 0.35, updatedVelocity.z);
            }
            if (updatedVelocity.y < -0.35) {
                updatedVelocity = new Vec3(updatedVelocity.x, -0.35, updatedVelocity.z);
            }
            item.setDeltaMovement(updatedVelocity);
            if (item instanceof AttractTracked) {
                AttractTracked tracked = (AttractTracked)item;
                Vec3 appliedAcceleration = updatedVelocity.subtract(velocity);
                tracked.alcocraftplus$setAttractAccel(appliedAcceleration);
                tracked.alcocraftplus$setAttractTtl(2);
            }
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            if (!particleSources.contains(item) || serverLevel.getGameTime() % 20L != 0L) continue;
            Vec3 toWaist = AttractEffect.sphericalTargetAroundWaist(item, nearestHolder);
            AttractEffect.spawnDustLine(serverLevel, itemCenter, toWaist);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

