/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.itzme1on.alcocraftplus.core.compat.jei.keg.KegCategory;
import me.itzme1on.alcocraftplus.core.recipes.KegRecipes;
import me.itzme1on.alcocraftplus.core.registries.BlocksRegistry;
import me.itzme1on.alcocraftplus.core.registries.RecipesRegistry;
import me.itzme1on.alcocraftplus.core.utils.IdentifierUtil;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class AlcoJEIPlugin
implements IModPlugin {
    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new KegCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List kegHolderRecipes = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipesRegistry.KEG_RECIPE_TYPE.get());
        ArrayList kegRecipes = new ArrayList();
        kegHolderRecipes.iterator().forEachRemaining(recipeHolder -> kegRecipes.add((KegRecipes)recipeHolder.value()));
        registration.addRecipes(KegCategory.RECIPE_TYPE, kegRecipes);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return IdentifierUtil.of("jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksRegistry.KEG.get()), new RecipeType[]{KegCategory.RECIPE_TYPE});
    }
}

